/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.util.ArrayList;
import org.h2.api.DatabaseEventListener;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionFactory;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.ResultInterface;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.LobStorage;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionRemote
extends SessionWithState
implements SessionFactory,
DataHandler {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROWS = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int CHANGE_ID = 9;
    public static final int COMMAND_GET_META_DATA = 10;
    public static final int SESSION_PREPARE_READ_PARAMS = 11;
    public static final int SESSION_SET_ID = 12;
    public static final int SESSION_CANCEL_STATEMENT = 13;
    public static final int SESSION_CHECK_KEY = 14;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    public static final int STATUS_OK_STATE_CHANGED = 3;
    private TraceSystem traceSystem;
    private Trace trace;
    private ArrayList<Transfer> transferList = New.arrayList();
    private int nextId;
    private boolean autoCommit = true;
    private CommandInterface switchOffAutoCommit;
    private ConnectionInfo connectionInfo;
    private String databaseName;
    private String cipher;
    private byte[] fileEncryptionKey;
    private Object lobSyncObject = new Object();
    private String sessionId;
    private int clientVersion = 6;
    private boolean autoReconnect;
    private int lastReconnect;
    private SessionInterface embedded;
    private DatabaseEventListener eventListener;
    private LobStorage lobStorage;
    private boolean cluster;

    public SessionRemote() {
    }

    private SessionRemote(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    private Transfer initTransfer(ConnectionInfo connectionInfo, String string, String string2) throws IOException {
        Socket socket = NetUtils.createSocket(string2, 9092, connectionInfo.isSSL());
        Transfer transfer = new Transfer(this);
        transfer.setSocket(socket);
        transfer.setSSL(connectionInfo.isSSL());
        transfer.init();
        transfer.writeInt(this.clientVersion);
        transfer.writeInt(this.clientVersion);
        transfer.writeString(string);
        transfer.writeString(connectionInfo.getOriginalURL());
        transfer.writeString(connectionInfo.getUserName());
        transfer.writeBytes(connectionInfo.getUserPasswordHash());
        transfer.writeBytes(connectionInfo.getFilePasswordHash());
        String[] stringArray = connectionInfo.getKeys();
        transfer.writeInt(stringArray.length);
        for (String string3 : stringArray) {
            transfer.writeString(string3).writeString(connectionInfo.getProperty(string3));
        }
        try {
            this.done(transfer);
            if (this.clientVersion >= 6) {
                this.clientVersion = transfer.readInt();
            }
        }
        catch (DbException dbException) {
            transfer.close();
            throw dbException;
        }
        this.autoCommit = true;
        return transfer;
    }

    @Override
    public void cancel() {
    }

    public void cancelStatement(int n) {
        for (Transfer transfer : this.transferList) {
            try {
                Transfer transfer2 = transfer.openNewConnection();
                transfer2.init();
                transfer2.writeInt(this.clientVersion);
                transfer2.writeInt(this.clientVersion);
                transfer2.writeString(null);
                transfer2.writeString(null);
                transfer2.writeString(this.sessionId);
                transfer2.writeInt(13);
                transfer2.writeInt(n);
                transfer2.close();
            }
            catch (IOException iOException) {
                this.trace.debug("Could not cancel statement", iOException);
            }
        }
    }

    private void switchOffAutoCommitIfCluster() {
        if (this.autoCommit && this.transferList.size() > 1) {
            if (this.switchOffAutoCommit == null) {
                this.switchOffAutoCommit = this.prepareCommand("SET AUTOCOMMIT FALSE", Integer.MAX_VALUE);
            }
            this.switchOffAutoCommit.executeUpdate();
            this.autoCommit = true;
            this.cluster = true;
        }
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public void autoCommitIfCluster() {
        if (this.autoCommit && this.transferList != null && this.transferList.size() > 1) {
            int n = 0;
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = this.transferList.get(i);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeServer(iOException, i--, ++n);
                }
            }
        }
    }

    private String getFilePrefix(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('/');
        for (int i = 0; i < this.databaseName.length(); ++i) {
            char c = this.databaseName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    @Override
    public int getPowerOffCount() {
        return 0;
    }

    @Override
    public void setPowerOffCount(int n) {
        throw DbException.getUnsupportedException("remote");
    }

    @Override
    public SessionInterface createSession(ConnectionInfo connectionInfo) {
        return new SessionRemote(connectionInfo).connectEmbeddedOrServer(false);
    }

    private SessionInterface connectEmbeddedOrServer(boolean bl) {
        ConnectionInfo connectionInfo = this.connectionInfo;
        if (connectionInfo.isRemote()) {
            this.connectServer(connectionInfo);
            return this;
        }
        boolean bl2 = Boolean.valueOf(connectionInfo.getProperty("AUTO_SERVER", "false"));
        ConnectionInfo connectionInfo2 = null;
        try {
            if (bl2) {
                connectionInfo2 = (ConnectionInfo)connectionInfo.clone();
                this.connectionInfo = (ConnectionInfo)connectionInfo.clone();
            }
            SessionFactory sessionFactory = (SessionFactory)Class.forName("org.h2.engine.Session").newInstance();
            if (bl) {
                connectionInfo.setProperty("OPEN_NEW", "true");
            }
            return sessionFactory.createSession(connectionInfo);
        }
        catch (Exception exception) {
            String string;
            DbException dbException = DbException.convert(exception);
            if (dbException.getErrorCode() == 90020 && bl2 && (string = ((JdbcSQLException)dbException.getSQLException()).getSQL()) != null) {
                connectionInfo2.setServerKey(string);
                connectionInfo2.removeProperty("OPEN_NEW", null);
                this.connectServer(connectionInfo2);
                return this;
            }
            throw dbException;
        }
    }

    private void connectServer(ConnectionInfo connectionInfo) {
        String[] stringArray;
        String string;
        int n;
        String string2 = connectionInfo.getName();
        if (string2.startsWith("//")) {
            string2 = string2.substring("//".length());
        }
        if ((n = string2.indexOf(47)) < 0) {
            throw connectionInfo.getFormatException();
        }
        this.databaseName = string2.substring(n + 1);
        String string3 = string2.substring(0, n);
        this.traceSystem = new TraceSystem(null);
        String string4 = connectionInfo.getProperty(10, null);
        if (string4 != null) {
            int n2 = Integer.parseInt(string4);
            String string5 = this.getFilePrefix(SysProperties.CLIENT_TRACE_DIRECTORY);
            try {
                String string6 = IOUtils.createTempFile(string5, ".trace.db", false, false);
                this.traceSystem.setFileName(string6);
                this.traceSystem.setLevelFile(n2);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, string5);
            }
        }
        if ((string = connectionInfo.getProperty(9, null)) != null) {
            int n3 = Integer.parseInt(string);
            this.traceSystem.setLevelSystemOut(n3);
        }
        this.trace = this.traceSystem.getTrace("jdbc");
        String string7 = null;
        if (string3.indexOf(44) >= 0) {
            string7 = StringUtils.quoteStringSQL(string3);
            connectionInfo.setProperty("CLUSTER", string7);
        }
        this.autoReconnect = Boolean.valueOf(connectionInfo.getProperty("AUTO_RECONNECT", "false"));
        boolean bl = Boolean.valueOf(connectionInfo.getProperty("AUTO_SERVER", "false"));
        if (bl && string7 != null) {
            throw DbException.getUnsupportedException("autoServer && serverList != null");
        }
        this.autoReconnect |= bl;
        if (this.autoReconnect && (stringArray = connectionInfo.getProperty("DATABASE_EVENT_LISTENER")) != null) {
            stringArray = StringUtils.trim((String)stringArray, true, true, "'");
            try {
                this.eventListener = (DatabaseEventListener)Utils.loadUserClass((String)stringArray).newInstance();
            }
            catch (Throwable throwable) {
                throw DbException.convert(throwable);
            }
        }
        this.cipher = connectionInfo.getProperty("CIPHER");
        if (this.cipher != null) {
            this.fileEncryptionKey = MathUtils.secureRandomBytes(32);
        }
        stringArray = StringUtils.arraySplit(string3, ',', true);
        int n4 = stringArray.length;
        this.transferList.clear();
        boolean bl2 = false;
        try {
            for (int i = 0; i < n4; ++i) {
                try {
                    Transfer transfer = this.initTransfer(connectionInfo, this.databaseName, stringArray[i]);
                    this.transferList.add(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
            this.checkClosed();
            if (bl2) {
                this.switchOffCluster();
            }
            this.switchOffAutoCommitIfCluster();
        }
        catch (DbException dbException) {
            this.traceSystem.close();
            throw dbException;
        }
        this.upgradeClientVersionIfPossible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeClientVersionIfPossible() {
        Object object;
        try {
            Value[] valueArray;
            int n;
            object = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", 1);
            ParameterInterface parameterInterface = object.getParameters().get(0);
            parameterInterface.setValue(ValueString.get("info.BUILD_ID"), false);
            ResultInterface object2 = object.executeQuery(1, false);
            if (object2.next() && (n = (valueArray = object2.currentRow())[0].getInt()) > 71) {
                this.clientVersion = 6;
            }
            object2.close();
        }
        catch (DbException dbException) {
            this.trace.error("Error trying to upgrade client version", dbException);
        }
        if (this.clientVersion >= 6) {
            this.sessionId = Utils.convertBytesToString(MathUtils.secureRandomBytes(32));
            object = this;
            synchronized (object) {
                for (Transfer transfer : this.transferList) {
                    try {
                        this.traceOperation("SESSION_SET_ID", 0);
                        transfer.writeInt(12);
                        transfer.writeString(this.sessionId);
                        this.done(transfer);
                    }
                    catch (Exception exception) {
                        this.trace.error("sessionSetId", exception);
                    }
                }
            }
        }
    }

    private void switchOffCluster() {
        CommandInterface commandInterface = this.prepareCommand("SET CLUSTER ''", Integer.MAX_VALUE);
        commandInterface.executeUpdate();
    }

    public void removeServer(IOException iOException, int n, int n2) {
        this.transferList.remove(n);
        if (this.transferList.size() == 0 && this.autoReconnect(n2)) {
            return;
        }
        this.checkClosed();
        this.switchOffCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandInterface prepareCommand(String string, int n) {
        SessionRemote sessionRemote = this;
        synchronized (sessionRemote) {
            this.checkClosed();
            return new CommandRemote(this, this.transferList, string, n);
        }
    }

    public boolean autoReconnect(int n) {
        if (!this.isClosed()) {
            return false;
        }
        if (!this.autoReconnect) {
            return false;
        }
        if (!this.cluster && !this.autoCommit) {
            return false;
        }
        if (n > SysProperties.MAX_RECONNECT) {
            return false;
        }
        ++this.lastReconnect;
        while (true) {
            try {
                this.embedded = this.connectEmbeddedOrServer(false);
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 90135) {
                    throw dbException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        if (this.embedded == this) {
            this.embedded = null;
        } else {
            this.connectEmbeddedOrServer(true);
        }
        this.recreateSessionState();
        if (this.eventListener != null) {
            this.eventListener.setProgress(4, this.databaseName, n, SysProperties.MAX_RECONNECT);
        }
        return true;
    }

    public void checkClosed() {
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.transferList != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (Transfer transfer : this.transferList) {
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                    }
                    catch (Exception exception) {
                        this.trace.error("close", exception);
                    }
                }
            }
            this.transferList = null;
        }
        this.traceSystem.close();
        if (this.embedded != null) {
            this.embedded.close();
            this.embedded = null;
        }
    }

    @Override
    public Trace getTrace() {
        return this.traceSystem.getTrace("jdbc");
    }

    public int getNextId() {
        return this.nextId++;
    }

    public int getCurrentId() {
        return this.nextId;
    }

    public void done(Transfer transfer) throws IOException {
        transfer.flush();
        int n = transfer.readInt();
        if (n == 0) {
            String string = transfer.readString();
            String string2 = transfer.readString();
            String string3 = transfer.readString();
            int n2 = transfer.readInt();
            String string4 = transfer.readString();
            JdbcSQLException jdbcSQLException = new JdbcSQLException(string2, string3, string, n2, null, string4);
            if (n2 == 90067) {
                IOException iOException = new IOException(jdbcSQLException.toString());
                iOException.initCause(jdbcSQLException);
                throw iOException;
            }
            throw DbException.convert(jdbcSQLException);
        }
        if (n == 2) {
            this.transferList = null;
        } else if (n == 3) {
            this.sessionStateChanged = true;
        } else if (n != 1) {
            throw DbException.get(90067, "unexpected status " + n);
        }
    }

    public boolean isClustered() {
        return this.transferList.size() > 1;
    }

    @Override
    public boolean isClosed() {
        return this.transferList == null || this.transferList.size() == 0;
    }

    public void traceOperation(String string, int n) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug(string + " " + n);
        }
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void freeUpDiskSpace() {
    }

    @Override
    public String getDatabasePath() {
        return "";
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return 65536;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        if (bl && !IOUtils.exists(string)) {
            throw DbException.get(90030, string);
        }
        FileStore fileStore = this.cipher == null ? FileStore.open(this, string, string2) : FileStore.open(this, string, string2, this.cipher, this.fileEncryptionKey, 0);
        fileStore.setCheckedWriting(false);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    @Override
    public DataHandler getDataHandler() {
        return this;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public int getLastReconnect() {
        return this.lastReconnect;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public boolean isReconnectNeeded(boolean bl) {
        return false;
    }

    @Override
    public SessionInterface reconnect(boolean bl) {
        return this;
    }

    @Override
    public void afterWriting() {
    }

    @Override
    public LobStorage getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorage(this);
        }
        return this.lobStorage;
    }

    @Override
    public Connection getLobConnection() {
        return null;
    }
}

