/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    private int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int n) {
        super(session);
        this.type = n;
    }

    public void setString(String string) {
        this.stringValue = string;
    }

    public boolean isTransactional() {
        switch (this.type) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 26: 
            case 28: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    public int update() {
        Database database = this.session.getDatabase();
        String string = SetTypes.getTypeName(this.type);
        block0 : switch (this.type) {
            case 24: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 2) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "ALLOW_LITERALS");
                }
                database.setAllowLiterals(n);
                this.addOrUpdateSetting(string, null, n);
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 13: {
                if ("TRUE".equals(this.stringValue)) break;
                String string2 = StringUtils.quoteStringSQL(this.stringValue);
                if (!string2.equals(database.getCluster()) && !string2.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(string2);
                this.addOrUpdateSetting(database.getSystemSession(), string, string2, 0);
                database.getSystemSession().commit(true);
                break;
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getSQL());
                }
                StringBuilder stringBuilder = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0);
                } else {
                    int n = this.getIntValue();
                    stringBuilder.append(" STRENGTH ");
                    if (n == 3) {
                        stringBuilder.append("IDENTICAL");
                    } else if (n == 0) {
                        stringBuilder.append("PRIMARY");
                    } else if (n == 1) {
                        stringBuilder.append("SECONDARY");
                    } else if (n == 2) {
                        stringBuilder.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, n);
                }
                this.addOrUpdateSetting(string, stringBuilder.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int n = CompressTool.getInstance().getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(n == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(string, this.stringValue, 0);
                break;
            }
            case 34: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int n = this.getIntValue();
                this.addOrUpdateSetting(string, null, n);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 6: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                switch (n) {
                    case 0: {
                        database.setExclusiveSession(null, false);
                        break block0;
                    }
                    case 1: {
                        database.setExclusiveSession(this.session, false);
                        break block0;
                    }
                    case 2: {
                        database.setExclusiveSession(this.session, true);
                        break block0;
                    }
                }
                throw DbException.getInvalidValueException("" + n, "EXCLUSIVE");
            }
            case 1: {
                this.session.getUser().checkAdmin();
                database.setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 5: {
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 19: {
                int n = this.getIntValue();
                if (n < 0 || n > 2) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "LOG");
                }
                if (n != 0) break;
                this.session.getUser().checkAdmin();
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "MAX_LENGTH_INPLACE_LOB");
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 2: {
                this.session.getUser().checkAdmin();
                database.setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 16: {
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "MAX_MEMORY_UNDO");
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 32: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                database.setMaxOperationMemory(n);
                break;
            }
            case 3: {
                this.session.getUser().checkAdmin();
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                database.setMode(mode);
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(this.getIntValue() == 1);
                break;
            }
            case 31: {
                if (database.isMultiVersion() == (this.getIntValue() == 1)) break;
                throw DbException.get(90133, "MVCC");
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 36: {
                int n = this.getIntValue();
                this.session.setQueryTimeout(n);
                break;
            }
            case 37: {
                int n = this.getIntValue();
                this.session.setRedoLogBinary(n == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "REFERENTIAL_INTEGRITY");
                }
                database.setReferentialIntegrity(n == 1);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.stringValue);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(n);
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            case 20: {
                if (this.getIntValue() < 0) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "THROTTLE");
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 29: {
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("" + this.getIntValue(), "UNDO_LOG");
                }
                this.session.setUndoLogEnabled(n == 1);
                break;
            }
            case 35: {
                Expression expression = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expression.getValue(this.session));
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(string, null, this.getIntValue());
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        return 0;
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int n) {
        this.expression = ValueExpression.get(ValueInt.get(n));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String string, String string2, int n) {
        this.addOrUpdateSetting(this.session, string, string2, n);
    }

    private void addOrUpdateSetting(Session session, String string, String string2, int n) {
        Database database = session.getDatabase();
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(string);
        boolean bl = false;
        if (setting == null) {
            bl = true;
            int n2 = this.getObjectId();
            setting = new Setting(database, n2, string);
        }
        if (string2 != null) {
            if (!bl && setting.getStringValue().equals(string2)) {
                return;
            }
            setting.setStringValue(string2);
        } else {
            if (!bl && setting.getIntValue() == n) {
                return;
            }
            setting.setIntValue(n);
        }
        if (bl) {
            database.addDatabaseObject(session, setting);
        } else {
            database.update(session, setting);
        }
    }

    public boolean needRecompile() {
        return false;
    }

    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] stringArray) {
        this.stringValueList = stringArray;
    }
}

