/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import java.util.ArrayList;
import org.h2.java.ClassObj;
import org.h2.java.Expr;
import org.h2.java.JavaParser;
import org.h2.java.MethodObj;
import org.h2.java.Type;

class CallExpr
implements Expr {
    final JavaParser context;
    final Expr expr;
    final ArrayList<Expr> args = new ArrayList();
    final boolean isStatic;
    final String className;
    final String name;
    private ClassObj classObj;
    private MethodObj method;

    CallExpr(JavaParser javaParser, Expr expr, String string, String string2, boolean bl) {
        this.context = javaParser;
        this.expr = expr;
        this.className = string;
        this.name = string2;
        this.isStatic = bl;
    }

    private void initMethod() {
        if (this.method != null) {
            return;
        }
        this.classObj = this.className != null ? this.context.getClassObj(this.className) : this.expr.getType().classObj;
        this.method = this.classObj.getMethod(this.name, this.args);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.initMethod();
        String string = this.method.isVirtual ? "virtual_" + this.method.name + "[CLASS_ID(" + this.expr.toString() + ")]" : JavaParser.toC(this.classObj.toString() + "." + this.method.name);
        stringBuilder.append(string).append("(");
        int n = 0;
        if (this.expr != null) {
            stringBuilder.append(this.expr.toString());
            ++n;
        }
        for (Expr expr : this.args) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            ++n;
            stringBuilder.append(expr);
        }
        return stringBuilder.append(")").toString();
    }

    public Type getType() {
        this.initMethod();
        return this.method.returnType;
    }
}

