/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueResultSet
extends Value {
    private final ResultSet result;

    private ValueResultSet(ResultSet resultSet) {
        this.result = resultSet;
    }

    public static ValueResultSet get(ResultSet resultSet) {
        ValueResultSet valueResultSet = new ValueResultSet(resultSet);
        return valueResultSet;
    }

    public static ValueResultSet getCopy(ResultSet resultSet, int n) {
        try {
            int n2;
            Object[] objectArray;
            int n3;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n4 = resultSetMetaData.getColumnCount();
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.setAutoClose(false);
            ValueResultSet valueResultSet = new ValueResultSet(simpleResultSet);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray = resultSetMetaData.getColumnLabel(n3 + 1);
                n2 = resultSetMetaData.getColumnType(n3 + 1);
                int n5 = resultSetMetaData.getPrecision(n3 + 1);
                int n6 = resultSetMetaData.getScale(n3 + 1);
                simpleResultSet.addColumn((String)objectArray, n2, n5, n6);
            }
            for (n3 = 0; n3 < n && resultSet.next(); ++n3) {
                objectArray = new Object[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    objectArray[n2] = resultSet.getObject(n2 + 1);
                }
                simpleResultSet.addRow(objectArray);
            }
            return valueResultSet;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public int getType() {
        return 18;
    }

    public long getPrecision() {
        return 0L;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public String getString() {
        try {
            StatementBuilder statementBuilder = new StatementBuilder("(");
            this.result.beforeFirst();
            ResultSetMetaData resultSetMetaData = this.result.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            while (this.result.next()) {
                if (n2 > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (int i = 0; i < n; ++i) {
                    statementBuilder.appendExceptFirst(", ");
                    int n3 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(i + 1));
                    Value value = DataType.readValue(null, this.result, i + 1, n3);
                    statementBuilder.append(value.getString());
                }
                statementBuilder.append(')');
                ++n2;
            }
            this.result.beforeFirst();
            return statementBuilder.append(')').toString();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        throw this.throwUnsupportedExceptionForType("<=>");
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return 0;
    }

    public Object getObject() {
        return this.result;
    }

    public ResultSet getResultSet() {
        return this.result;
    }

    public void set(PreparedStatement preparedStatement, int n) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    public String getSQL() {
        return "";
    }
}

