/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.util.StringUtils;

public class IOUtils {
    private IOUtils() {
    }

    public static void closeSilently(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                IOUtils.trace("closeSilently", null, outputStream);
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        try {
            while (l > 0L) {
                long l2 = inputStream.skip(l);
                if (l2 <= 0L) {
                    throw new EOFException();
                }
                l -= l2;
            }
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static void skipFully(Reader reader, long l) throws IOException {
        try {
            while (l > 0L) {
                long l2 = reader.skip(l);
                if (l2 <= 0L) {
                    throw new EOFException();
                }
                l -= l2;
            }
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static long copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l = IOUtils.copyAndCloseInput(inputStream, outputStream);
            outputStream.close();
            long l2 = l;
            return l2;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }

    public static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l = IOUtils.copy(inputStream, outputStream);
            return l;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        try {
            long l2 = 0L;
            int n = (int)Math.min(l, 4096L);
            byte[] byArray = new byte[n];
            while (l > 0L && (n = inputStream.read(byArray, 0, n)) >= 0) {
                if (outputStream != null) {
                    outputStream.write(byArray, 0, n);
                }
                l2 += (long)n;
                l -= (long)n;
                n = (int)Math.min(l, 4096L);
            }
            return l2;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static long copyAndCloseInput(Reader reader, Writer writer, long l) throws IOException {
        try {
            long l2 = 0L;
            int n = (int)Math.min(l, 4096L);
            char[] cArray = new char[n];
            while (l > 0L && (n = reader.read(cArray, 0, n)) >= 0) {
                if (writer != null) {
                    writer.write(cArray, 0, n);
                }
                l -= (long)n;
                n = (int)Math.min(l, 4096L);
                l2 += (long)n;
            }
            long l3 = l2;
            return l3;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            reader.close();
        }
    }

    public static void closeSilently(InputStream inputStream) {
        if (inputStream != null) {
            try {
                IOUtils.trace("closeSilently", null, inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] readBytesAndClose(InputStream inputStream, int n) throws IOException {
        try {
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            int n2 = Math.min(4096, n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            IOUtils.copy(inputStream, byteArrayOutputStream, n);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringAndClose(Reader reader, int n) throws IOException {
        try {
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            int n2 = Math.min(4096, n);
            StringWriter stringWriter = new StringWriter(n2);
            IOUtils.copyAndCloseInput(reader, stringWriter, n);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3;
            int n4 = 0;
            for (int i = Math.min(n2, byArray.length); i > 0 && (n3 = inputStream.read(byArray, n, i)) >= 0; i -= n3) {
                n4 += n3;
                n += n3;
            }
            return n4;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static int readFully(Reader reader, char[] cArray, int n) throws IOException {
        try {
            int n2;
            int n3 = 0;
            int n4 = Math.min(n, cArray.length);
            if (n4 == 0) {
                return 0;
            }
            while ((n2 = n4 - n3) > 0 && (n2 = reader.read(cArray, n3, n2)) >= 0) {
                n3 += n2;
            }
            return n3 <= 0 ? -1 : n3;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static Reader getBufferedReader(InputStream inputStream) {
        try {
            return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static Reader getReader(InputStream inputStream) {
        try {
            return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static Writer getBufferedWriter(OutputStream outputStream) {
        try {
            return outputStream == null ? null : new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static InputStream getInputStream(String string) {
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(StringUtils.utf8Encode(string));
    }

    public static Reader getReader(String string) {
        return string == null ? null : new StringReader(string);
    }

    public static Reader getAsciiReader(InputStream inputStream) {
        try {
            return inputStream == null ? null : new InputStreamReader(inputStream, "US-ASCII");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static void mkdirs(File file) throws IOException {
        for (int i = 0; i < 5; ++i) {
            if (file.exists()) {
                if (file.isDirectory()) {
                    return;
                }
                throw new IOException("Could not create directory, because a file with the same name already exists: " + file.getAbsolutePath());
            }
            if (!file.mkdirs()) continue;
            return;
        }
        throw new IOException("Could not create directory: " + file.getAbsolutePath());
    }

    public static void setLength(RandomAccessFile randomAccessFile, long l) throws IOException {
        try {
            IOUtils.trace("setLength", null, randomAccessFile);
            randomAccessFile.setLength(l);
        }
        catch (IOException iOException) {
            int n;
            long l2;
            long l3 = randomAccessFile.length();
            if (l < l3) {
                throw iOException;
            }
            long l4 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l3);
            int n2 = 0x100000;
            int n3 = (int)Math.min(l2, (long)n2);
            byte[] byArray = new byte[n3];
            for (l2 = l - l3; l2 > 0L; l2 -= (long)n) {
                n = (int)Math.min(l2, (long)n2);
                randomAccessFile.write(byArray, 0, n);
            }
            randomAccessFile.seek(l4);
        }
    }

    public static String getFileName(String string) {
        return IOUtils.getFileSystem(string).getFileName(string);
    }

    public static boolean canWrite(String string) {
        return IOUtils.getFileSystem(string).canWrite(string);
    }

    public static boolean setReadOnly(String string) {
        return IOUtils.getFileSystem(string).setReadOnly(string);
    }

    public static void copy(String string, String string2) {
        IOUtils.getFileSystem(string).copy(string, string2);
    }

    public static boolean createNewFile(String string) {
        return IOUtils.getFileSystem(string).createNewFile(string);
    }

    public static FileObject openFileObject(String string, String string2) throws IOException {
        return IOUtils.getFileSystem(string).openFileObject(string, string2);
    }

    public static String normalize(String string) {
        return IOUtils.getFileSystem(string).normalize(string);
    }

    public static boolean tryDelete(String string) {
        return IOUtils.getFileSystem(string).tryDelete(string);
    }

    public static boolean isReadOnly(String string) {
        return IOUtils.getFileSystem(string).isReadOnly(string);
    }

    public static boolean exists(String string) {
        return IOUtils.getFileSystem(string).exists(string);
    }

    public static long length(String string) {
        return IOUtils.getFileSystem(string).length(string);
    }

    public static String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        return IOUtils.getFileSystem(string).createTempFile(string, string2, bl, bl2);
    }

    public static String getParent(String string) {
        return IOUtils.getFileSystem(string).getParent(string);
    }

    public static String[] listFiles(String string) {
        return IOUtils.getFileSystem(string).listFiles(string);
    }

    public static boolean isDirectory(String string) {
        return IOUtils.getFileSystem(string).isDirectory(string);
    }

    public static boolean isAbsolute(String string) {
        return IOUtils.getFileSystem(string).isAbsolute(string);
    }

    public static String getAbsolutePath(String string) {
        return IOUtils.getFileSystem(string).getAbsolutePath(string);
    }

    public static boolean fileStartsWith(String string, String string2) {
        return IOUtils.getFileSystem(string).fileStartsWith(string, string2);
    }

    public static InputStream openFileInputStream(String string) throws IOException {
        return IOUtils.getFileSystem(string).openFileInputStream(string);
    }

    public static OutputStream openFileOutputStream(String string, boolean bl) {
        return IOUtils.getFileSystem(string).openFileOutputStream(string, bl);
    }

    public static void rename(String string, String string2) {
        IOUtils.getFileSystem(string).rename(string, string2);
    }

    public static void createDirs(String string) {
        IOUtils.getFileSystem(string).createDirs(string);
    }

    public static void delete(String string) {
        IOUtils.getFileSystem(string).delete(string);
    }

    public static void deleteRecursive(String string, boolean bl) {
        IOUtils.getFileSystem(string).deleteRecursive(string, bl);
    }

    public static long getLastModified(String string) {
        return IOUtils.getFileSystem(string).getLastModified(string);
    }

    public static String unwrap(String string) {
        return IOUtils.getFileSystem(string).unwrap(string);
    }

    private static FileSystem getFileSystem(String string) {
        return FileSystem.getInstance(string);
    }

    public static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("IOUtils." + string + " " + string2 + " " + object);
        }
    }
}

