/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int META_TABLE_TYPE_COUNT = 29;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START", "CONTAINS_UNCOMMITTED");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setObjectName("QUERY_STATISTICS");
                columnArray = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME LONG", "MAX_EXECUTION_TIME LONG", "CUMULATIVE_EXECUTION_TIME LONG", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1))).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(string, n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private ArrayList<Table> getTablesByName(Session session, String string) {
        ArrayList<Table> arrayList = this.database.getTableOrViewByName(string);
        for (Table table : session.getLocalTempTables()) {
            if (!table.getName().equals(string)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        Value value3 = this.database.getMode().lowerCaseIdentifiers ? ValueStringIgnoreCase.get(string) : ValueString.get(string);
        if (value != null && database.compare(value3, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(value3, value2) <= 0;
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Row> generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> arrayList = New.arrayList();
        String string = this.identifier(this.database.getShortName());
        boolean bl = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    String inputStreamReader = this.identifier(table.getName());
                    if (!this.checkIndex(session, inputStreamReader, value, value2) || this.hideTable(table, session)) continue;
                    String string12 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    String string2 = table.getCreateSQL();
                    if (!bl && string2 != null && string2.contains("--hide--")) {
                        string2 = "-";
                    }
                    this.add(arrayList, string, this.identifier(table.getSchema().getName()), inputStreamReader, table.getTableType(), string12, string2, MetaTable.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null, table.getClass().getName(), "" + table.getRowCountApproximation());
                }
                break;
            }
            case 1: {
                ArrayList<Table> arrayList2;
                if (value != null && value2 != null && value.equals(value2)) {
                    String string5 = this.identifier(value.getString());
                    arrayList2 = this.getTablesByName(session, string5);
                } else {
                    arrayList2 = this.getAllTables(session);
                }
                for (Table sequence : arrayList2) {
                    String store = this.identifier(sequence.getName());
                    if (!this.checkIndex(session, store, value, value2) || this.hideTable(sequence, session)) continue;
                    Column[] dbException = sequence.getColumns();
                    String string3 = this.database.getCompareMode().getName();
                    for (int i = 0; i < dbException.length; ++i) {
                        Column l3 = dbException[i];
                        Sequence sequence2 = l3.getSequence();
                        this.add(arrayList, string, this.identifier(sequence.getSchema().getName()), store, this.identifier(l3.getName()), String.valueOf(i + 1), l3.getDefaultSQL(), l3.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(l3.getType()), "" + l3.getPrecisionAsInt(), "" + l3.getPrecisionAsInt(), "" + l3.getPrecisionAsInt(), "10", "" + l3.getScale(), CHARACTER_SET_NAME, string3, this.identifier(DataType.getDataType((int)l3.getType()).name), "" + (l3.isNullable() ? 1 : 0), "" + (l3.getComputed() ? "TRUE" : "FALSE"), "" + l3.getSelectivity(), l3.getCheckConstraintSQL(session, l3.getName()), sequence2 == null ? null : sequence2.getName(), MetaTable.replaceNullWithEmpty(l3.getComment()), null);
                    }
                }
                break;
            }
            case 2: {
                for (Table object2 : this.getAllTables(session)) {
                    String role = this.identifier(object2.getName());
                    if (!this.checkIndex(session, role, value, value2) || this.hideTable(object2, session)) continue;
                    ArrayList<Index> csv = object2.getIndexes();
                    ArrayList<Constraint> arrayList2 = object2.getConstraints();
                    for (int dbObject3 = 0; csv != null && dbObject3 < csv.size(); ++dbObject3) {
                        Object object;
                        Index index = csv.get(dbObject3);
                        if (index.getCreateSQL() == null) continue;
                        String table = null;
                        for (int i = 0; arrayList2 != null && i < arrayList2.size(); ++i) {
                            object = arrayList2.get(i);
                            if (!((Constraint)object).usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (!((Constraint)object).getConstraintType().equals("PRIMARY KEY")) continue;
                                table = ((DbObjectBase)object).getName();
                                continue;
                            }
                            table = ((DbObjectBase)object).getName();
                        }
                        IndexColumn[] indexColumnArray = index.getIndexColumns();
                        object = index instanceof MultiVersionIndex ? ((MultiVersionIndex)index).getBaseIndex().getClass().getName() : index.getClass().getName();
                        for (int i = 0; i < indexColumnArray.length; ++i) {
                            IndexColumn indexColumn = indexColumnArray[i];
                            Column column = indexColumn.column;
                            this.add(arrayList, new String[]{string, this.identifier(object2.getSchema().getName()), role, index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (i + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", MetaTable.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), "" + index.getId(), "" + indexColumn.sortType, table, object});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(arrayList, "TABLE");
                this.add(arrayList, "TABLE LINK");
                this.add(arrayList, "SYSTEM TABLE");
                this.add(arrayList, "VIEW");
                this.add(arrayList, "EXTERNAL");
                break;
            }
            case 5: {
                this.add(arrayList, string);
                break;
            }
            case 6: {
                long indexColumnArray2;
                MVTableEngine.Store table;
                Object dbException2;
                Object object3;
                for (Setting dataType : this.database.getAllSettings()) {
                    String functionAlias = dataType.getStringValue();
                    if (functionAlias == null) {
                        functionAlias = "" + dataType.getIntValue();
                    }
                    this.add(arrayList, this.identifier(dataType.getName()), functionAlias);
                }
                this.add(arrayList, "info.BUILD_ID", "188");
                this.add(arrayList, "info.VERSION_MAJOR", "1");
                this.add(arrayList, "info.VERSION_MINOR", "4");
                this.add(arrayList, "info.VERSION", "" + Constants.getFullVersion());
                if (bl) {
                    object3 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (Object dbException2 : object3) {
                        this.add(arrayList, "property." + (String)dbException2, Utils.getProperty((String)dbException2, ""));
                    }
                }
                this.add(arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(arrayList, "MODE", this.database.getMode().getName());
                this.add(arrayList, "MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0");
                this.add(arrayList, "MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE");
                this.add(arrayList, "QUERY_TIMEOUT", "" + session.getQueryTimeout());
                this.add(arrayList, "RETENTION_TIME", "" + this.database.getRetentionTime());
                this.add(arrayList, "LOG", "" + this.database.getLogMode());
                object3 = New.arrayList();
                HashMap<String, String> schemaObject = this.database.getSettings().getSettings();
                for (String javaMethodArray : schemaObject.keySet()) {
                    ((ArrayList)object3).add(javaMethodArray);
                }
                Collections.sort(object3);
                Object functionAlias = ((ArrayList)object3).iterator();
                while (functionAlias.hasNext()) {
                    String table2 = functionAlias.next();
                    this.add(arrayList, table2, schemaObject.get(table2));
                }
                if (!this.database.isPersistent()) break;
                functionAlias = this.database.getPageStore();
                if (functionAlias != null) {
                    this.add(arrayList, "info.FILE_WRITE_TOTAL", "" + ((PageStore)functionAlias).getWriteCountTotal());
                    this.add(arrayList, "info.FILE_WRITE", "" + ((PageStore)functionAlias).getWriteCount());
                    this.add(arrayList, "info.FILE_READ", "" + ((PageStore)functionAlias).getReadCount());
                    this.add(arrayList, "info.PAGE_COUNT", "" + ((PageStore)functionAlias).getPageCount());
                    this.add(arrayList, "info.PAGE_SIZE", "" + ((PageStore)functionAlias).getPageSize());
                    this.add(arrayList, "info.CACHE_MAX_SIZE", "" + ((PageStore)functionAlias).getCache().getMaxMemory());
                    this.add(arrayList, "info.CACHE_SIZE", "" + ((PageStore)functionAlias).getCache().getMemory());
                }
                if ((table = this.database.getMvStore()) == null) break;
                dbException2 = table.getStore().getFileStore();
                this.add(arrayList, "info.FILE_WRITE", "" + ((FileStore)dbException2).getWriteCount());
                this.add(arrayList, "info.FILE_READ", "" + ((FileStore)dbException2).getReadCount());
                try {
                    indexColumnArray2 = ((FileStore)dbException2).getFile().size();
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, "Can not get size");
                }
                int n = 4096;
                long l = indexColumnArray2 / (long)n;
                this.add(arrayList, "info.PAGE_COUNT", "" + l);
                this.add(arrayList, "info.PAGE_SIZE", "" + n);
                this.add(arrayList, "info.CACHE_MAX_SIZE", "" + table.getStore().getCacheSize());
                this.add(arrayList, "info.CACHE_SIZE", "" + table.getStore().getCacheSizeUsed());
                break;
            }
            case 4: {
                for (DataType user : DataType.getTypes()) {
                    if (user.hidden || user.sqlType == 0) continue;
                    this.add(arrayList, user.name, String.valueOf(user.sqlType), String.valueOf(MathUtils.convertLongToInt(user.maxPrecision)), user.prefix, user.suffix, user.params, String.valueOf(user.autoIncrement), String.valueOf(user.minScale), String.valueOf(user.maxScale), user.decimal ? "10" : null, String.valueOf(user.sqlTypePos), String.valueOf(user.caseSensitive), "1", "3");
                }
                break;
            }
            case 7: {
                String string13 = "/org/h2/res/help.csv";
                try {
                    byte[] role = Utils.getResource(string13);
                    InputStreamReader schema = new InputStreamReader(new ByteArrayInputStream(role));
                    Csv locale = new Csv();
                    locale.setLineCommentCharacter('#');
                    ResultSet string20 = locale.read(schema, null);
                    boolean indexColumnArray = false;
                    while (string20.next()) {
                        void session2;
                        this.add(arrayList, String.valueOf((int)session2), string20.getString(1).trim(), string20.getString(2).trim(), string20.getString(3).trim(), string20.getString(4).trim());
                        ++session2;
                    }
                    break;
                }
                catch (Exception right) {
                    throw DbException.convert(right);
                }
            }
            case 8: {
                for (SchemaObject dbObject : this.database.getAllSchemaObjects(3)) {
                    Sequence dbObject2 = (Sequence)dbObject;
                    this.add(arrayList, string, this.identifier(dbObject2.getSchema().getName()), this.identifier(dbObject2.getName()), String.valueOf(dbObject2.getCurrentValue()), String.valueOf(dbObject2.getIncrement()), dbObject2.getBelongsToTable() ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(dbObject2.getComment()), String.valueOf(dbObject2.getCacheSize()), String.valueOf(dbObject2.getMinValue()), String.valueOf(dbObject2.getMaxValue()), dbObject2.getCycle() ? "TRUE" : "FALSE", "" + dbObject2.getId());
                }
                break;
            }
            case 9: {
                for (User schemaObject : this.database.getAllUsers()) {
                    if (!bl && session.getUser() != schemaObject) continue;
                    this.add(arrayList, this.identifier(schemaObject.getName()), String.valueOf(schemaObject.isAdmin()), MetaTable.replaceNullWithEmpty(schemaObject.getComment()), "" + schemaObject.getId());
                }
                break;
            }
            case 10: {
                for (Role role : this.database.getAllRoles()) {
                    if (!bl && !session.getUser().isRoleGranted(role)) continue;
                    this.add(arrayList, this.identifier(role.getName()), MetaTable.replaceNullWithEmpty(role.getComment()), "" + role.getId());
                }
                break;
            }
            case 11: {
                if (!bl) break;
                for (Right right : this.database.getAllRights()) {
                    String string21;
                    Role dbObject = right.getGrantedRole();
                    DbObject tableView = right.getGrantee();
                    String string4 = string21 = tableView.getType() == 2 ? "USER" : "ROLE";
                    if (dbObject == null) {
                        String string5;
                        DbObject dbObject3 = right.getGrantedObject();
                        Schema schema = null;
                        DbObjectBase dbObjectBase = null;
                        if (dbObject3 != null) {
                            if (dbObject3 instanceof Schema) {
                                schema = (Schema)dbObject3;
                            } else if (dbObject3 instanceof Table) {
                                dbObjectBase = (Table)dbObject3;
                                schema = ((SchemaObjectBase)dbObjectBase).getSchema();
                            }
                        }
                        String string6 = dbObjectBase != null ? this.identifier(dbObjectBase.getName()) : "";
                        String string7 = string5 = schema != null ? this.identifier(schema.getName()) : "";
                        if (!this.checkIndex(session, string6, value, value2)) continue;
                        this.add(arrayList, this.identifier(tableView.getName()), string21, "", right.getRights(), string5, string6, "" + right.getId());
                        continue;
                    }
                    this.add(arrayList, this.identifier(tableView.getName()), string21, this.identifier(dbObject.getName()), "", "", "", "" + right.getId());
                }
                break;
            }
            case 12: {
                for (SchemaObject right : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias.JavaMethod[] constraintReferential;
                    FunctionAlias functionAlias = (FunctionAlias)right;
                    try {
                        constraintReferential = functionAlias.getJavaMethods();
                    }
                    catch (DbException string26) {
                        constraintReferential = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod javaMethod : constraintReferential) {
                        int n = javaMethod.getDataType() == 0 ? 1 : 2;
                        this.add(arrayList, string, functionAlias.getSchema().getName(), this.identifier(functionAlias.getName()), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), DataType.getDataType((int)javaMethod.getDataType()).name, "" + javaMethod.getParameterCount(), "" + n, MetaTable.replaceNullWithEmpty(functionAlias.getComment()), "" + functionAlias.getId(), functionAlias.getSource());
                    }
                }
                for (UserAggregate table : this.database.getAllAggregates()) {
                    int string22 = 2;
                    this.add(arrayList, string, "PUBLIC", this.identifier(table.getName()), table.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), DataType.getDataType((int)0).name, "1", "" + string22, MetaTable.replaceNullWithEmpty(table.getComment()), "" + table.getId(), "");
                }
                break;
            }
            case 21: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias.JavaMethod[] string25;
                    FunctionAlias inDoubtTransaction = (FunctionAlias)schemaObject;
                    try {
                        string25 = inDoubtTransaction.getJavaMethods();
                    }
                    catch (DbException dbException) {
                        string25 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod javaMethod : string25) {
                        Object object;
                        if (javaMethod.getDataType() != 0) {
                            object = DataType.getDataType(javaMethod.getDataType());
                            this.add(arrayList, string, inDoubtTransaction.getSchema().getName(), this.identifier(inDoubtTransaction.getName()), inDoubtTransaction.getJavaClassName(), inDoubtTransaction.getJavaMethodName(), "" + javaMethod.getParameterCount(), "0", "P0", "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), object.name, "" + MathUtils.convertLongToInt(object.defaultPrecision), "" + object.defaultScale, "10", "2", "5", "", null);
                        }
                        object = javaMethod.getColumnClasses();
                        for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                            if (javaMethod.hasConnectionParam() && i == 0) continue;
                            Class<?> clazz = object[i];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            int n2 = clazz.isPrimitive() ? 0 : 1;
                            this.add(arrayList, string, inDoubtTransaction.getSchema().getName(), this.identifier(inDoubtTransaction.getName()), inDoubtTransaction.getJavaClassName(), inDoubtTransaction.getJavaMethodName(), "" + javaMethod.getParameterCount(), "" + (i + (javaMethod.hasConnectionParam() ? 0 : 1)), "P" + (i + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + MathUtils.convertLongToInt(dataType.defaultPrecision), "" + dataType.defaultScale, "10", "" + n2, "1", "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string19 = this.database.getCompareMode().getName();
                for (Schema constraint : this.database.getAllSchemas()) {
                    this.add(arrayList, string, this.identifier(constraint.getName()), this.identifier(constraint.getOwner().getName()), CHARACTER_SET_NAME, string19, "PUBLIC".equals(constraint.getName()) ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(constraint.getComment()), "" + constraint.getId());
                }
                break;
            }
            case 14: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String value3;
                    Table valueExpression;
                    DbObject constraint = schemaObject.getGrantedObject();
                    if (!(constraint instanceof Table) || (valueExpression = (Table)constraint) == null || this.hideTable(valueExpression, session) || !this.checkIndex(session, value3 = this.identifier(valueExpression.getName()), value, value2)) continue;
                    this.addPrivileges(arrayList, schemaObject.getGrantee(), string, valueExpression, null, schemaObject.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String string8;
                    Table table;
                    DbObject constant = schemaObject.getGrantedObject();
                    if (!(constant instanceof Table) || (table = (Table)constant) == null || this.hideTable(table, session) || !this.checkIndex(session, string8 = this.identifier(table.getName()), value, value2)) continue;
                    DbObject dbObject = schemaObject.getGrantee();
                    int n = schemaObject.getRightMask();
                    for (Column column : table.getColumns()) {
                        this.addPrivileges(arrayList, dbObject, string, table, column.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale locale : Collator.getAvailableLocales()) {
                    this.add(arrayList, CompareMode.getName(locale), locale.toString());
                }
                break;
            }
            case 17: {
                for (Table schemaObject : this.getAllTables(session)) {
                    String triggerObject;
                    if (!schemaObject.getTableType().equals("VIEW") || !this.checkIndex(session, triggerObject = this.identifier(schemaObject.getName()), value, value2)) continue;
                    TableView session3 = (TableView)schemaObject;
                    this.add(arrayList, string, this.identifier(schemaObject.getSchema().getName()), triggerObject, schemaObject.getCreateSQL(), "NONE", "NO", session3.isInvalid() ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(session3.getComment()), "" + session3.getId());
                }
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList5 = this.database.getInDoubtTransactions();
                if (arrayList5 == null || !bl) break;
                for (InDoubtTransaction inDoubtTransaction : arrayList5) {
                    this.add(arrayList, inDoubtTransaction.getTransactionName(), inDoubtTransaction.getState());
                }
                break;
            }
            case 19: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential string30 = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = string30.getColumns();
                    IndexColumn[] indexColumnArray2 = string30.getRefColumns();
                    Table table = string30.getTable();
                    Table table3 = string30.getRefTable();
                    String string9 = this.identifier(table3.getName());
                    if (!this.checkIndex(session, string9, value, value2)) continue;
                    int n = MetaTable.getRefAction(string30.getUpdateAction());
                    int n3 = MetaTable.getRefAction(string30.getDeleteAction());
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(arrayList, string, this.identifier(table3.getSchema().getName()), this.identifier(table3.getName()), this.identifier(indexColumnArray2[i].column.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(indexColumnArray[i].column.getName()), String.valueOf(i + 1), String.valueOf(n), String.valueOf(n3), this.identifier(string30.getName()), this.identifier(string30.getUniqueIndex().getName()), "7");
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject table : this.database.getAllSchemaObjects(5)) {
                    void var14_152;
                    String string10;
                    Constraint constraint = (Constraint)table;
                    String string11 = constraint.getConstraintType();
                    String string12 = null;
                    Object var14_153 = null;
                    Table table4 = constraint.getTable();
                    if (this.hideTable(table4, session)) continue;
                    Index index = constraint.getUniqueIndex();
                    String string13 = null;
                    if (index != null) {
                        string13 = index.getName();
                    }
                    if (!this.checkIndex(session, string10 = this.identifier(table4.getName()), value, value2)) continue;
                    if (string11.equals("CHECK")) {
                        string12 = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (string11.equals("UNIQUE") || string11.equals("PRIMARY KEY")) {
                        IndexColumn[] indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (string11.equals("REFERENTIAL")) {
                        IndexColumn[] indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string14 = null;
                    if (var14_152 != null) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        for (void var24_212 : var14_152) {
                            statementBuilder.appendExceptFirst(",");
                            statementBuilder.append(var24_212.column.getName());
                        }
                        string14 = statementBuilder.toString();
                    }
                    this.add(arrayList, string, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), string11, string, this.identifier(table4.getSchema().getName()), string10, string13, string12, string14, MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId());
                }
                break;
            }
            case 22: {
                for (SchemaObject statementBuilder : this.database.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)statementBuilder;
                    ValueExpression valueExpression = constant.getValue();
                    this.add(arrayList, string, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), MetaTable.replaceNullWithEmpty(constant.getComment()), valueExpression.getSQL(), "" + constant.getId());
                }
                break;
            }
            case 23: {
                for (UserDataType string29 : this.database.getAllUserDataTypes()) {
                    Column queryEntry = string29.getColumn();
                    this.add(arrayList, string, "PUBLIC", this.identifier(string29.getName()), queryEntry.getDefaultSQL(), queryEntry.isNullable() ? "YES" : "NO", "" + queryEntry.getDataType().sqlType, "" + queryEntry.getPrecisionAsInt(), "" + queryEntry.getScale(), queryEntry.getDataType().name, "" + queryEntry.getSelectivity(), "" + queryEntry.getCheckConstraintSQL(session, "VALUE"), MetaTable.replaceNullWithEmpty(string29.getComment()), "" + string29.getCreateSQL(), "" + string29.getId());
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)schemaObject;
                    Table table = triggerObject.getTable();
                    this.add(arrayList, string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + triggerObject.isBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.isNoWait(), MetaTable.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 25: {
                long l = System.currentTimeMillis();
                for (Session session2 : this.database.getSessions(false)) {
                    if (!bl && session2 != session) continue;
                    Command command = session2.getCurrentCommand();
                    long l2 = session2.getCurrentCommandStart();
                    if (l2 == 0L) {
                        l2 = l;
                    }
                    this.add(arrayList, "" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(l2).toString(), "" + session2.containsUncommitted());
                }
                break;
            }
            case 26: {
                for (Session session3 : this.database.getSessions(false)) {
                    if (!bl && session3 != session) continue;
                    for (Table table : session3.getLocks()) {
                        this.add(arrayList, table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                String string15;
                for (String string16 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string16);
                    this.add(arrayList, "@" + string16, "SET @" + string16 + " " + value3.getSQL());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(arrayList, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StatementBuilder statementBuilder = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object object : stringArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(StringUtils.quoteIdentifier((String)object));
                    }
                    this.add(arrayList, "SCHEMA_SEARCH_PATH", statementBuilder.toString());
                }
                if ((string15 = session.getCurrentSchemaName()) == null) break;
                this.add(arrayList, "SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(string15));
                break;
            }
            case 28: {
                QueryStatisticsData queryStatisticsData = this.database.getQueryStatisticsData();
                if (queryStatisticsData == null) break;
                for (QueryStatisticsData.QueryEntry queryEntry : queryStatisticsData.getQueries()) {
                    this.add(arrayList, queryEntry.sqlStatement, "" + queryEntry.count, "" + queryEntry.executionTimeMin, "" + queryEntry.executionTimeMax, "" + queryEntry.executionTimeCumulative, "" + queryEntry.executionTimeMean, "" + queryEntry.getExecutionTimeStandardDeviation(), "" + queryEntry.rowCountMin, "" + queryEntry.rowCountMax, "" + queryEntry.rowCountCumulative, "" + queryEntry.rowCountMean, "" + queryEntry.getRowCountStandardDeviation());
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private static int getRefAction(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + n);
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4);
        }
    }

    private void add(ArrayList<Row> arrayList, String ... stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i];
            value = column.convert(value);
            valueArray[i] = value;
        }
        Row row = new Row(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public String getTableType() {
        return "SYSTEM TABLE";
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = New.arrayList();
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 29;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

