/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private Expression limitExpr;
    private TableFilter sourceTableFilter;
    private HashSet<Long> keysFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setKeysFilter(HashSet<Long> hashSet) {
        this.keysFilter = hashSet;
    }

    @Override
    public int update() {
        Object object;
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fire(this.session, 4, true);
        table.lock(this.session, true, false);
        int n = -1;
        if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            n = ((Value)object).getInt();
        }
        object = new RowList(this.session);
        Throwable throwable = null;
        try {
            this.setCurrentRowNumber(0L);
            int n2 = 0;
            while (n != 0 && this.targetTableFilter.next()) {
                this.setCurrentRowNumber(((RowList)object).size() + 1);
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                Row row = this.targetTableFilter.get();
                if (this.keysFilter != null && !this.keysFilter.contains(row.getKey())) continue;
                boolean bl = false;
                if (table.fireRow()) {
                    bl = table.fireBeforeRow(this.session, row, null);
                }
                if (!bl) {
                    if (table.isMVStore()) {
                        boolean bl2 = bl = table.lockRow(this.session, row) == null;
                    }
                    if (!bl) {
                        ((RowList)object).add(row);
                    }
                }
                if (n < 0 || ++n2 < n) continue;
                break;
            }
            int n3 = 0;
            ((RowList)object).reset();
            while (((RowList)object).hasNext()) {
                if ((++n3 & 0x7F) == 0) {
                    this.checkCanceled();
                }
                Row row = ((RowList)object).next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                ((RowList)object).reset();
                while (((RowList)object).hasNext()) {
                    Row row = ((RowList)object).next();
                    table.fireAfterRow(this.session, row, null, false);
                }
            }
            table.fire(this.session, 4, false);
            int n4 = n2;
            return n4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((RowList)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((RowList)object).close();
                }
            }
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        this.targetTableFilter.getPlanSQL(stringBuilder, false);
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(stringBuilder);
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT (");
            this.limitExpr.getUnenclosedSQL(stringBuilder).append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            if (this.sourceTableFilter != null) {
                this.condition.mapColumns(this.sourceTableFilter, 0, 0);
            }
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        TableFilter[] tableFilterArray = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem planItem = this.targetTableFilter.getBestPlanItem(this.session, tableFilterArray, 0, new AllColumnsForPlan(tableFilterArray));
        this.targetTableFilter.setPlanItem(planItem);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 58;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public TableFilter getTableFilter() {
        return this.targetTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }
}

