/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test;

import com.h3xstream.findbugs.test.EasyBugReporter;
import com.h3xstream.findbugs.test.matcher.BugInstanceMatcherBuilder;
import com.h3xstream.findbugs.test.service.ClassFileLocator;
import com.h3xstream.findbugs.test.service.FindBugsLauncher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mockito.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class BaseDetectorTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDetectorTest.class);
    private static final boolean DEBUG = false;
    private ClassFileLocator classFileLocator = new ClassFileLocator();
    private FindBugsLauncher findBugsLauncher = new FindBugsLauncher();

    public String getClassFilePath(String path) {
        if (StringUtils.countMatches((String)path, (String)".") > 1 && !path.endsWith(".jar")) {
            path = path.replaceAll("\\.", "/");
        }
        return this.classFileLocator.getClassFilePath(path);
    }

    public String getJspFilePath(String path) {
        return this.classFileLocator.getJspFilePath(path);
    }

    public String getJarFilePath(String path) {
        return this.classFileLocator.getJarFilePath(path);
    }

    public void analyze(String[] classFiles, BugReporter bugReporter) throws Exception {
        ArrayList<String> classPath = new ArrayList<String>();
        classPath.add(this.getPluginDepsJarPath());
        this.findBugsLauncher.analyze(classFiles, classPath.toArray(new String[classPath.size()]), bugReporter);
    }

    public void analyze(String[] classFiles, String[] classPathsOrig, BugReporter bugReporter) throws Exception {
        ArrayList<String> classPath = new ArrayList<String>(Arrays.asList(classPathsOrig));
        classPath.add(this.getPluginDepsJarPath());
        this.findBugsLauncher.analyze(classFiles, classPath.toArray(new String[classPath.size()]), bugReporter);
    }

    private String getPluginDepsJarPath() {
        ClassLoader cl = this.getClass().getClassLoader();
        String url = cl.getResource("PluginDepsClassPathFinder.class").toExternalForm();
        String separateFile = "/target/classes/PluginDepsClassPathFinder.class";
        String insideJar = "!/PluginDepsClassPathFinder.class";
        for (String suffix : Arrays.asList(separateFile, insideJar)) {
            if (!url.endsWith(suffix)) continue;
            String filename = url.substring(0, url.length() - suffix.length());
            if (suffix == separateFile) {
                filename = filename + "/target/classes/";
            }
            for (String prefix : Arrays.asList("file:", "jar:file:")) {
                if (!filename.startsWith(prefix)) continue;
                filename = filename.substring(prefix.length());
            }
            return filename;
        }
        throw new RuntimeException("Unable to locate the dependencies for test in the classpath.");
    }

    public BugInstanceMatcherBuilder bugDefinition() {
        return new BugInstanceMatcherBuilder();
    }

    public static BugInstance anyBugs() {
        return (BugInstance)Matchers.any();
    }

    public static List<Integer> range(int from, int to) {
        ArrayList<Integer> rangeList = new ArrayList<Integer>();
        for (int i = from; i < Math.max(from, to); ++i) {
            rangeList.add(i);
        }
        return rangeList;
    }

    @BeforeClass
    public void before() {
        Class<?> concreteClass = this.getClass();
        log.info(">>>> Starting test suite " + concreteClass.getSimpleName() + " <<<<");
    }

    @AfterClass
    public void after() {
        System.gc();
    }

    public class SecurityReporter
    extends EasyBugReporter {
        public SecurityReporter() {
            this.getIncludeCategories().add("S");
        }
    }
}

