/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test;

import com.h3xstream.findbugs.test.FbTestGlobalSettings;
import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyBugReporter
extends AbstractBugReporter {
    private BugCollection bugCollection = new SortedBugCollection();
    private int bugInstanceCount;
    private static final Logger log = LoggerFactory.getLogger(EasyBugReporter.class);
    private List<String> includeCategories = new ArrayList<String>();

    public EasyBugReporter() {
        this.setPriorityThreshold(20);
    }

    public List<String> getIncludeCategories() {
        return this.includeCategories;
    }

    public void finish() {
    }

    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    public void doReportBug(BugInstance bugInstance) {
        if (this.includeCategories.size() > 0 && !this.includeCategories.contains(bugInstance.getCategoryAbbrev())) {
            return;
        }
        if (FbTestGlobalSettings.isRunningFromMaven()) {
            StringBuilder bugDetail = new StringBuilder();
            bugDetail.append("New bug ").append(bugInstance.getBugPattern().getType()).append(" ");
            if (bugInstance.getPrimaryClass() != null && bugInstance.getPrimaryMethod() != null && bugInstance.getPrimarySourceLineAnnotation() != null) {
                bugDetail.append("[").append(bugInstance.getPrimaryClass().getSimpleClassName()).append(".").append(bugInstance.getPrimaryMethod().getMethodName()).append("() at ").append(bugInstance.getPrimarySourceLineAnnotation().getStartLine()).append("]");
            } else if (bugInstance.getPrimaryClass() != null && bugInstance.getPrimaryField() != null && bugInstance.getPrimarySourceLineAnnotation() != null) {
                bugDetail.append("[").append(bugInstance.getPrimaryClass().getSimpleClassName()).append(".").append(bugInstance.getPrimaryField()).append(" at ").append(bugInstance.getPrimarySourceLineAnnotation().getStartLine()).append("]");
            }
            log.info(bugDetail.toString());
        } else {
            List<String> bugs;
            StringBuilder bugDetail = new StringBuilder();
            bugDetail.append("\n------------------------------------------------------").append("\nNew Bug Instance: [" + ++this.bugInstanceCount + "]").append("\n  message=" + bugInstance.getMessage()).append("\n  bugType=" + bugInstance.getBugPattern().getType()).append("  priority=" + bugInstance.getPriorityString()).append("  category=" + bugInstance.getCategoryAbbrev());
            if (bugInstance.getPrimaryClass() != null) {
                bugDetail.append("\n  class=" + bugInstance.getPrimaryClass().getClassName());
            }
            if (bugInstance.getPrimaryMethod() != null) {
                bugDetail.append("  method=" + bugInstance.getPrimaryMethod().getMethodName());
            }
            if (bugInstance.getPrimaryField() != null) {
                bugDetail.append("  field=" + bugInstance.getPrimaryField().getFieldName());
            }
            if (bugInstance.getPrimarySourceLineAnnotation() != null) {
                bugDetail.append("  line=" + bugInstance.getPrimarySourceLineAnnotation().getStartLine());
            }
            if ((bugs = this.getUnknownSources(bugInstance)).size() > 0) {
                bugDetail.append("\n  sources=" + Arrays.asList(bugs));
            }
            bugDetail.append("\n------------------------------------------------------");
            log.info(bugDetail.toString());
        }
    }

    private List<String> getUnknownSources(BugInstance bugInstance) {
        ArrayList<String> sources = new ArrayList<String>();
        for (BugAnnotation ann : bugInstance.getAnnotations()) {
            StringAnnotation value;
            if (!(ann instanceof StringAnnotation) || !(value = (StringAnnotation)ann).getDescription().equals("Unknown source")) continue;
            sources.add(value.getValue());
        }
        return sources;
    }

    public void reportAnalysisError(AnalysisError error) {
        if (error.getException() != null) {
            log.error(error.getException().getMessage(), error.getException());
        } else {
            log.error(error.getMessage());
        }
    }

    public void reportMissingClass(String className) {
    }
}

