/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test.jsp;

import com.h3xstream.findbugs.test.jsp.ClassMetadataLoadingException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DebugExtensionExtractor {
    @Nullable
    public String getDebugExtFromClass(InputStream classIn) throws IOException {
        AbstractClassVisitor visitor = new AbstractClassVisitor();
        try {
            ClassReader classReader = new ClassReader(classIn);
            classReader.accept((ClassVisitor)visitor, 0);
            return visitor.debug;
        }
        catch (Exception e) {
            throw new ClassMetadataLoadingException(e);
        }
    }

    public String getDebugSourceFromClass(InputStream classIn) throws IOException {
        AbstractClassVisitor visitor = new AbstractClassVisitor();
        try {
            ClassReader classReader = new ClassReader(classIn);
            classReader.accept((ClassVisitor)visitor, 0);
            return visitor.source;
        }
        catch (Exception e) {
            throw new ClassMetadataLoadingException(e);
        }
    }

    private static class AbstractClassVisitor
    extends ClassVisitor {
        protected String source;
        protected String debug;

        public AbstractClassVisitor() {
            super(327680);
        }

        public void visitSource(String source, String debug) {
            super.visitSource(source, debug);
            this.source = source;
            this.debug = debug;
        }
    }
}

