/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test.matcher;

import com.h3xstream.findbugs.test.matcher.BugInstanceMatcherBuilder;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugInstanceMatcher
extends BaseMatcher<BugInstance> {
    private static final Logger log = LoggerFactory.getLogger(BugInstanceMatcherBuilder.class);
    private static final Pattern ANON_FUNCTION_SCALA_PATTERN = Pattern.compile("\\$\\$anonfun\\$([^\\$]+)\\$");
    private String bugType;
    private String className;
    private String methodName;
    private String fieldName;
    private Integer lineNumber;
    private Integer lineNumberApprox;
    private String priority;
    private String jspFile;
    private List<Integer> multipleChoicesLine;
    private List<String> unknownSources;

    public BugInstanceMatcher(String bugType, String className, String methodName, String fieldName, Integer lineNumber, Integer lineNumberApprox, String priority, String jspFile, List<Integer> multipleChoicesLine, List<String> unknownSources) {
        this.bugType = bugType;
        this.className = className;
        this.methodName = methodName;
        this.fieldName = fieldName;
        this.lineNumber = lineNumber;
        this.lineNumberApprox = lineNumberApprox;
        this.priority = priority;
        this.jspFile = jspFile;
        this.multipleChoicesLine = multipleChoicesLine;
        this.unknownSources = unknownSources;
    }

    public boolean matches(Object obj) {
        if (obj instanceof BugInstance) {
            Object srcAnn;
            String fullName;
            ClassAnnotation classAnn;
            BugInstance bugInstance = (BugInstance)obj;
            boolean criteriaMatches = true;
            if (this.bugType != null) {
                criteriaMatches &= bugInstance.getType().equals(this.bugType);
            }
            if (this.priority != null) {
                criteriaMatches &= bugInstance.getPriorityString().equals(this.priority);
            }
            if (this.className != null) {
                classAnn = this.extractBugAnnotation(bugInstance, ClassAnnotation.class);
                if (classAnn == null) {
                    return false;
                }
                fullName = classAnn.getClassName();
                int startDot = fullName.lastIndexOf(".") + 1;
                int endDollar = fullName.indexOf(36);
                String simpleName = fullName.substring(startDot != -1 ? startDot : 0, endDollar != -1 ? endDollar : fullName.length());
                String simpleNameInner = fullName.substring(startDot != -1 ? startDot : 0, fullName.length());
                criteriaMatches &= fullName.equals(this.className) || simpleName.equals(this.className) || simpleNameInner.equals(this.className);
            }
            if (this.methodName != null) {
                MethodAnnotation methodAnn = this.extractBugAnnotation(bugInstance, MethodAnnotation.class);
                ClassAnnotation classAnn2 = this.extractBugAnnotation(bugInstance, ClassAnnotation.class);
                String fullClassName = classAnn2.getClassName();
                if (methodAnn == null) {
                    return false;
                }
                if (methodAnn.getMethodName().startsWith("apply") && fullClassName != null) {
                    Matcher m = ANON_FUNCTION_SCALA_PATTERN.matcher(fullClassName);
                    if (m.find()) {
                        criteriaMatches &= methodAnn.getMethodName().equals(this.methodName) || this.methodName.equals(m.group(1));
                    }
                } else {
                    criteriaMatches &= methodAnn.getMethodName().equals(this.methodName);
                }
            }
            if (this.fieldName != null) {
                FieldAnnotation fieldAnn = this.extractBugAnnotation(bugInstance, FieldAnnotation.class);
                if (fieldAnn == null) {
                    return false;
                }
                criteriaMatches &= fieldAnn.getFieldName().equals(this.fieldName);
            }
            if (this.lineNumber != null) {
                srcAnn = this.extractBugAnnotation(bugInstance, SourceLineAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                criteriaMatches &= srcAnn.getStartLine() <= this.lineNumber && this.lineNumber <= srcAnn.getEndLine();
            }
            if (this.lineNumberApprox != null) {
                srcAnn = this.extractBugAnnotation(bugInstance, SourceLineAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                criteriaMatches &= srcAnn.getStartLine() - 1 <= this.lineNumberApprox && this.lineNumberApprox <= srcAnn.getEndLine() + 1;
            }
            if (this.jspFile != null) {
                classAnn = this.extractBugAnnotation(bugInstance, ClassAnnotation.class);
                fullName = classAnn.getClassName().replaceAll("\\.", "/").replaceAll("_005f", "_").replaceAll("_jsp", ".jsp");
                criteriaMatches &= fullName.endsWith(this.jspFile);
            }
            if (this.multipleChoicesLine != null) {
                srcAnn = this.extractBugAnnotation(bugInstance, SourceLineAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                boolean found = false;
                for (Integer potentialMatch : this.multipleChoicesLine) {
                    if (srcAnn.getStartLine() - 1 > potentialMatch || potentialMatch > srcAnn.getEndLine() + 1) continue;
                    found = true;
                }
                criteriaMatches &= found;
            }
            if (this.unknownSources != null && this.unknownSources.size() > 0) {
                srcAnn = this.extractBugAnnotations(bugInstance, StringAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                boolean found = false;
                Iterator iterator = srcAnn.iterator();
                while (iterator.hasNext()) {
                    StringAnnotation strAnn = (StringAnnotation)iterator.next();
                    if (!strAnn.getDescription().equals("Unknown source") || !this.unknownSources.contains(strAnn.getValue())) continue;
                    found = true;
                }
                criteriaMatches &= found;
            }
            return criteriaMatches;
        }
        return false;
    }

    private <T> List<T> extractBugAnnotations(BugInstance bugInstance, Class<T> annotationType) {
        ArrayList<BugAnnotation> annotations = new ArrayList<BugAnnotation>();
        for (BugAnnotation annotation : bugInstance.getAnnotations()) {
            if (!annotation.getClass().equals(annotationType)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    private <T> T extractBugAnnotation(BugInstance bugInstance, Class<T> annotationType) {
        for (BugAnnotation annotation : bugInstance.getAnnotations()) {
            if (!annotation.getClass().equals(annotationType)) continue;
            return (T)annotation;
        }
        return null;
    }

    public void describeTo(Description description) {
        description.appendText("BugInstance with:\n");
        if (this.bugType != null) {
            description.appendText("bugType=").appendValue((Object)this.bugType).appendText(",");
        }
        if (this.className != null) {
            description.appendText("className=").appendValue((Object)this.className).appendText(",");
        }
        if (this.methodName != null) {
            description.appendText("methodName=").appendValue((Object)this.methodName).appendText(",");
        }
        if (this.fieldName != null) {
            description.appendText("fieldName=").appendValue((Object)this.fieldName).appendText(",");
        }
        if (this.lineNumber != null) {
            description.appendText("lineNumber=").appendValue((Object)this.lineNumber);
        }
    }
}

