/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test.matcher;

import com.h3xstream.findbugs.test.jsp.DebugExtensionExtractor;
import com.h3xstream.findbugs.test.jsp.SmapParser;
import com.h3xstream.findbugs.test.matcher.BugInstanceMatcher;
import com.h3xstream.findbugs.test.service.ClassFileLocator;
import edu.umd.cs.findbugs.BugInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.mockito.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugInstanceMatcherBuilder {
    private static final Logger log = LoggerFactory.getLogger(BugInstanceMatcherBuilder.class);
    private String bugType;
    private String className;
    private String methodName;
    private String fieldName;
    private Integer lineNumber;
    private Integer lineNumberApprox;
    private String priority;
    private String jspFile;
    private Integer jspLine;
    private List<String> unknownSources = new ArrayList<String>();

    public BugInstanceMatcherBuilder bugType(String bugType) {
        this.bugType = bugType;
        return this;
    }

    public BugInstanceMatcherBuilder inClass(String className) {
        this.className = className;
        return this;
    }

    public BugInstanceMatcherBuilder inMethod(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public BugInstanceMatcherBuilder atField(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public BugInstanceMatcherBuilder atLine(int lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @Deprecated
    public BugInstanceMatcherBuilder atLineApprox(int lineNumberApprox) {
        this.lineNumberApprox = lineNumberApprox;
        return this;
    }

    public BugInstanceMatcherBuilder withPriority(String priority) {
        this.priority = priority;
        return this;
    }

    public BugInstanceMatcherBuilder inJspFile(String jspFile) {
        this.jspFile = jspFile;
        return this;
    }

    public BugInstanceMatcherBuilder atJspLine(Integer jspLine) {
        this.jspLine = jspLine;
        return this;
    }

    public BugInstanceMatcherBuilder causeBySource(String unknownSource) {
        this.unknownSources.add(unknownSource);
        return this;
    }

    public BugInstance build() {
        List<Integer> multipleChoicesLine = null;
        if (this.jspLine != null) {
            if (this.jspFile != null) {
                multipleChoicesLine = BugInstanceMatcherBuilder.mapJspToJavaLine(this.jspFile, this.jspLine);
            } else {
                throw new RuntimeException("JSP file not set.");
            }
        }
        return (BugInstance)Matchers.argThat((Matcher)new BugInstanceMatcher(this.bugType, this.className, this.methodName, this.fieldName, this.lineNumber, this.lineNumberApprox, this.priority, this.jspFile, multipleChoicesLine, this.unknownSources));
    }

    private static List<Integer> mapJspToJavaLine(String jspFile, Integer jspLine) {
        ArrayList<Integer> outJavaLines = new ArrayList<Integer>();
        ClassFileLocator locator = new ClassFileLocator();
        String jspClassLocation = locator.getJspFilePath(jspFile);
        File smapFile = new File(jspClassLocation + ".smap");
        try {
            String debugInfo;
            if (smapFile.exists()) {
                debugInfo = IOUtils.toString((InputStream)new FileInputStream(smapFile), (String)"UTF-8");
            } else {
                if (!new File(jspClassLocation).exists()) {
                    throw new RuntimeException("Unable to locate the class file " + jspClassLocation);
                }
                debugInfo = new DebugExtensionExtractor().getDebugExtFromClass(new FileInputStream(jspClassLocation));
                if (debugInfo == null) {
                    throw new RuntimeException("SMAP info is missing. (" + smapFile + " or embedded in " + jspClassLocation + ")");
                }
            }
            SmapParser smapDebug = new SmapParser(debugInfo);
            for (Integer val : smapDebug.getOriginalLine(jspLine)) {
                outJavaLines.add(val);
            }
            log.info("The JSP line " + jspLine + " was mapped to " + Arrays.toString(outJavaLines.toArray()));
            if (outJavaLines.isEmpty()) {
                throw new RuntimeException("Unable to find the mapping for the JSP line " + jspLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open the smap file.", e);
        }
        return outJavaLines;
    }
}

