/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test.service;

import java.net.URISyntaxException;
import java.net.URL;
import org.testng.Assert;

public class ClassFileLocator {
    public String getClassFilePath(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource(path + ".class");
        if (url != null) {
            return this.getFilenameFromUrl(url);
        }
        url = cl.getResource(path);
        Assert.assertNotNull((Object)url, (String)("No class found for the path = " + path));
        return this.getFilenameFromUrl(url);
    }

    public String getJspFilePath(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        String generatedClassName = path.replaceAll("_", "_005f").replace(".jsp", "_jsp");
        URL url = cl.getResource("jsp/" + generatedClassName + ".class");
        if (url == null) {
            url = cl.getResource("org/apache/jsp/" + generatedClassName + ".class");
        }
        Assert.assertNotNull((Object)url, (String)("No jsp file found for the path = " + path));
        return this.getFilenameFromUrl(url);
    }

    public String getJarFilePath(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource(path);
        Assert.assertNotNull((Object)url, (String)("No jar found for the path = " + path));
        return this.getFilenameFromUrl(url);
    }

    private String getFilenameFromUrl(URL url) {
        String filename;
        try {
            filename = url.toURI().getPath();
        }
        catch (URISyntaxException e) {
            Assert.fail((String)("Failed to get file path = " + url), (Throwable)e);
            return null;
        }
        String prefix = "file:";
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
        }
        return filename;
    }
}

