/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findbugs.test.service;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FindBugsLauncher {
    private static final Logger log = LoggerFactory.getLogger(FindBugsLauncher.class);
    static Plugin loadedPlugin;

    public void analyze(String[] classFiles, BugReporter bugReporter) throws IOException, InterruptedException, PluginException, NoSuchFieldException, IllegalAccessException, URISyntaxException {
        this.analyze(classFiles, new String[0], bugReporter);
    }

    public void analyze(String[] classFiles, String[] classPaths, BugReporter bugReporter) throws IOException, InterruptedException, PluginException, NoSuchFieldException, IllegalAccessException, URISyntaxException {
        Project project = new Project();
        project.setProjectName("automate-test-project");
        for (String file : classFiles) {
            project.addFile(file);
        }
        for (String classpath : classPaths) {
            project.addAuxClasspathEntry(classpath);
        }
        if (loadedPlugin == null) {
            byte[] archive = this.buildFakePluginJar();
            File f = new File(System.getProperty("java.io.tmpdir"), "plugin.jar");
            log.info("Writing " + f.getCanonicalPath());
            f.deleteOnExit();
            FileOutputStream out = new FileOutputStream(f);
            out.write(archive);
            out.close();
            loadedPlugin = Plugin.loadCustomPlugin((URL)f.toURI().toURL(), (Project)project);
        }
        FindBugs2 engine = new FindBugs2();
        engine.setNoClassOk(true);
        engine.setMergeSimilarWarnings(false);
        engine.setBugReporter(bugReporter);
        engine.setProject(project);
        engine.setProgressCallback((FindBugsProgress)Mockito.mock(FindBugsProgress.class));
        engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        UserPreferences prefs = UserPreferences.createDefaultUserPreferences();
        ProjectFilterSettings filter = prefs.getFilterSettings();
        filter.setMinRank(20);
        filter.setDisplayFalseWarnings(true);
        filter.setMinPriority("Low");
        engine.setUserPreferences(prefs);
        log.info("Analyzing... {}", (Object[])classFiles);
        engine.execute();
    }

    private byte[] buildFakePluginJar() throws IOException, URISyntaxException {
        ClassLoader cl = this.getClass().getClassLoader();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(buffer);
        URL metadata = cl.getResource("metadata");
        if (metadata != null) {
            File dir = new File(metadata.toURI());
            this.addFilesToStream(cl, jar, dir, "");
        }
        jar.finish();
        jar.close();
        return buffer.toByteArray();
    }

    private void addFilesToStream(ClassLoader cl, JarOutputStream jar, File dir, String path) throws IOException {
        for (File nextFile : dir.listFiles()) {
            if (nextFile.isFile()) {
                String resource = path + nextFile.getName();
                jar.putNextEntry(new ZipEntry(resource));
                jar.write(IOUtils.toByteArray((InputStream)cl.getResourceAsStream("metadata/" + resource)));
                continue;
            }
            this.addFilesToStream(cl, jar, nextFile, path + nextFile.getName() + "/");
        }
    }
}

