/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.testng;

import com.h3xstream.findbugs.test.FbTestGlobalSettings;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class VerboseTestListener
extends TestListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(VerboseTestListener.class);

    public void onTestFailure(ITestResult tr) {
        log.error(tr.getName() + " failed", tr.getThrowable());
    }

    public void onStart(ITestContext ctx) {
        log.info("<<<<<<<<<<<<<<<<<<<< {} started >>>>>>>>>>>>>>>>>>>>", (Object)ctx.getName());
        FbTestGlobalSettings.setRunningFromMaven(true);
    }

    public void onFinish(ITestContext ctx) {
        System.gc();
        Runtime rt = Runtime.getRuntime();
        long inMb = 0x100000L;
        log.info("Total memory : " + rt.totalMemory() / inMb);
        log.info("Free memory  : " + rt.freeMemory() / inMb);
        log.info("Memory usage : " + (rt.totalMemory() - rt.freeMemory()) / inMb);
        log.info("Process      : " + ManagementFactory.getRuntimeMXBean().getName());
        log.info("<<<<<<<<<<<<<<<<<<<< {} finished >>>>>>>>>>>>>>>>>>>>", (Object)ctx.getName());
    }
}

