/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonarqube.ws.client.Headers;
import org.sonarqube.ws.client.Parameters;
import org.sonarqube.ws.client.WsRequest;

abstract class BaseRequest<SELF extends BaseRequest>
implements WsRequest {
    private final String path;
    private String mediaType = "";
    private final DefaultParameters parameters = new DefaultParameters();
    private final DefaultHeaders headers = new DefaultHeaders();

    BaseRequest(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public SELF setMediaType(String s) {
        return (SELF)this;
    }

    public SELF setParam(String key, String value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, Integer value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, Long value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, Float value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, Boolean value) {
        return this.setSingleValueParam(key, value);
    }

    private SELF setSingleValueParam(String key, Object value) {
        return (SELF)this;
    }

    public SELF setParam(String key, Collection<? extends Object> values) {
        return (SELF)this;
    }

    @Override
    public Map<String, String> getParams() {
        return null;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    public SELF setHeader(String name, String value) {
        return (SELF)this;
    }

    private static class DefaultHeaders
    implements Headers {
        private final Map<String, String> keyValues = new HashMap<String, String>();

        private DefaultHeaders() {
        }

        @Override
        public Optional<String> getValue(String name) {
            return null;
        }

        private DefaultHeaders setValue(String name, String value) {
            return this;
        }

        @Override
        public Set<String> getNames() {
            return null;
        }
    }

    private static class DefaultParameters
    implements Parameters {
        private final Map<String, List<String>> keyValues = null;

        private DefaultParameters() {
        }

        public String getValue(String key) {
            return this.keyValues.containsKey(key) ? this.keyValues.get(key).get(0) : null;
        }

        public List<String> getValues(String key) {
            return this.keyValues.get(key);
        }

        public Set<String> getKeys() {
            return this.keyValues.keySet();
        }

        private DefaultParameters setValue(String key, String value) {
            return this;
        }

        private DefaultParameters setValues(String key, Collection<String> values) {
            return this;
        }
    }
}

