/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.taintanalysis.data.TaintLocation;
import com.h3xstream.findsecbugs.taintanalysis.data.UnknownSource;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.bcel.generic.ObjectType;

public class Taint {
    private State state;
    private static final int INVALID_INDEX = -1;
    private int variableIndex;
    private Set<TaintLocation> taintLocations;
    private Set<TaintLocation> unknownLocations;
    private Set<Integer> parameters;
    private State nonParametricState;
    private ObjectType realInstanceClass;
    private String realInstanceClassName;
    private Set<Tag> tags;
    private Set<Tag> tagsToRemove;
    private String constantValue;
    private String potentialValue;
    private String debugInfo = null;
    private Set<UnknownSource> sources;

    public Taint(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            throw new IllegalArgumentException("state not allowed");
        }
        this.state = state;
        this.variableIndex = -1;
        this.nonParametricState = State.INVALID;
        this.realInstanceClass = null;
        this.constantValue = null;
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            this.debugInfo = "?";
        }
    }

    public Taint(Taint taint) {
        Objects.requireNonNull(taint, "taint is null");
        assert (taint.state != null);
        this.state = taint.state;
        this.variableIndex = taint.variableIndex;
        if (taint.taintLocations != null) {
            this.taintLocations = new HashSet<TaintLocation>(taint.taintLocations);
        }
        if (taint.unknownLocations != null) {
            this.unknownLocations = new HashSet<TaintLocation>(taint.unknownLocations);
        }
        if (taint.parameters != null) {
            this.parameters = new HashSet<Integer>(taint.parameters);
        }
        this.nonParametricState = taint.nonParametricState;
        this.realInstanceClass = taint.realInstanceClass;
        if (taint.hasTags()) {
            this.tags = EnumSet.copyOf(taint.tags);
        }
        if (taint.isRemovingTags()) {
            this.tagsToRemove = EnumSet.copyOf(taint.tagsToRemove);
        }
        this.constantValue = taint.constantValue;
        this.potentialValue = taint.potentialValue;
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            this.debugInfo = taint.debugInfo;
        }
        if (taint.sources != null) {
            this.sources = new HashSet<UnknownSource>(taint.sources);
        }
    }

    public boolean isInformative() {
        if (!this.isUnknown()) {
            return true;
        }
        if (this.hasParameters()) {
            return true;
        }
        if (this.getRealInstanceClass() != null) {
            return true;
        }
        return this.hasTags() || this.isRemovingTags();
    }

    public State getState() {
        assert (this.state != null && this.state != State.INVALID);
        return this.state;
    }

    void setState(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            throw new IllegalArgumentException("state not allowed to be set");
        }
        this.state = state;
    }

    public int getVariableIndex() {
        if (this.variableIndex == -1) {
            throw new IllegalStateException("index not set or has been invalidated");
        }
        assert (this.variableIndex >= 0);
        return this.variableIndex;
    }

    public boolean hasValidVariableIndex() {
        return this.variableIndex != -1;
    }

    void setVariableIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index");
        }
        this.variableIndex = index;
    }

    void invalidateVariableIndex() {
        this.variableIndex = -1;
    }

    public void addLocation(TaintLocation location, boolean isKnownTaintSource) {
        Objects.requireNonNull(location, "location is null");
        if (isKnownTaintSource) {
            if (this.taintLocations == null) {
                this.taintLocations = new HashSet<TaintLocation>();
            }
            this.taintLocations.add(location);
        } else {
            if (this.unknownLocations == null) {
                this.unknownLocations = new HashSet<TaintLocation>();
            }
            this.unknownLocations.add(location);
        }
    }

    public Set<TaintLocation> getTaintedLocations() {
        if (this.taintLocations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.taintLocations);
    }

    public Collection<TaintLocation> getUnknownLocations() {
        if (this.unknownLocations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.unknownLocations);
    }

    public Collection<TaintLocation> getAllLocations() {
        if (this.unknownLocations != null && this.taintLocations != null) {
            ArrayList<TaintLocation> allLocations = new ArrayList<TaintLocation>(this.unknownLocations.size() + this.taintLocations.size());
            allLocations.addAll(this.unknownLocations);
            allLocations.addAll(this.taintLocations);
            return allLocations;
        }
        if (this.unknownLocations != null) {
            return this.getUnknownLocations();
        }
        return this.getTaintedLocations();
    }

    public boolean isSafe() {
        return this.state.isSafe;
    }

    public boolean isTainted() {
        return this.state.isTainted;
    }

    public boolean isUnknown() {
        return this.state.isUnknown;
    }

    void addParameter(int parameterIndex) {
        if (parameterIndex < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        if (this.parameters == null) {
            this.parameters = new HashSet<Integer>();
        }
        this.parameters.add(parameterIndex);
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public Set<Integer> getParameters() {
        if (this.parameters == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.parameters);
    }

    public State getNonParametricState() {
        return this.nonParametricState;
    }

    void setNonParametricState(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            throw new IllegalArgumentException("state not allowed to be set");
        }
        this.nonParametricState = state;
    }

    public ObjectType getRealInstanceClass() {
        return this.realInstanceClass;
    }

    void setRealInstanceClass(ObjectType objectType) {
        this.realInstanceClass = objectType;
    }

    public String getRealInstanceClassName() {
        if (this.realInstanceClass == null) {
            return null;
        }
        if (this.realInstanceClassName == null) {
            this.realInstanceClassName = ClassName.toSlashedClassName((String)this.realInstanceClass.getClassName());
        }
        return this.realInstanceClassName;
    }

    public boolean addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = EnumSet.noneOf(Tag.class);
        }
        return this.tags.add(tag);
    }

    public boolean hasTag(Tag tag) {
        return this.tags != null && this.tags.contains((Object)tag);
    }

    public boolean hasOneTag(Tag ... tags) {
        if (this.tags == null) {
            return false;
        }
        for (Tag t : tags) {
            if (!this.tags.contains((Object)t)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public Set<Tag> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean removeTag(Tag tag) {
        if (this.tagsToRemove == null) {
            this.tagsToRemove = EnumSet.noneOf(Tag.class);
        }
        this.tagsToRemove.add(tag);
        return this.tags != null && this.tags.remove((Object)tag);
    }

    public boolean isRemovingTags() {
        return this.tagsToRemove != null && !this.tagsToRemove.isEmpty();
    }

    public Set<Tag> getTagsToRemove() {
        if (this.tagsToRemove == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.tagsToRemove);
    }

    public String getConstantValue() {
        return this.constantValue;
    }

    public void setConstantValue(String value) {
        this.constantValue = value;
    }

    public String getPotentialValue() {
        return this.potentialValue;
    }

    public void setPotentialValue(String value) {
        this.potentialValue = value;
    }

    public String getConstantOrPotentialValue() {
        return this.constantValue != null ? this.constantValue : this.potentialValue;
    }

    public static Taint valueOf(String stateName) {
        return Taint.valueOf(State.valueOf(stateName));
    }

    public static Taint valueOf(State state) {
        Objects.requireNonNull(state, "state is null");
        if (state == State.INVALID) {
            return null;
        }
        return new Taint(state);
    }

    public static Taint merge(Taint a, Taint b) {
        int unknownLocationsSize;
        int taintLocationsSize;
        if (a == null) {
            if (b == null) {
                return null;
            }
            return new Taint(b);
        }
        if (b == null) {
            return new Taint(a);
        }
        assert (a != null && b != null);
        Taint result = new Taint(State.merge(a.getState(), b.getState()));
        if (a.variableIndex == b.variableIndex) {
            result.variableIndex = a.variableIndex;
        }
        if ((taintLocationsSize = (a.taintLocations != null ? a.taintLocations.size() : 0) + (b.taintLocations != null ? b.taintLocations.size() : 0)) > 0) {
            result.taintLocations = new HashSet<TaintLocation>(taintLocationsSize);
        }
        if (a.taintLocations != null) {
            result.taintLocations.addAll(a.taintLocations);
        }
        if (b.taintLocations != null) {
            result.taintLocations.addAll(b.taintLocations);
        }
        if ((unknownLocationsSize = (a.unknownLocations != null ? a.unknownLocations.size() : 0) + (b.unknownLocations != null ? b.unknownLocations.size() : 0)) > 0) {
            result.unknownLocations = new HashSet<TaintLocation>(unknownLocationsSize);
        }
        if (a.unknownLocations != null) {
            result.unknownLocations.addAll(a.unknownLocations);
        }
        if (b.unknownLocations != null) {
            result.unknownLocations.addAll(b.unknownLocations);
        }
        if (!result.isTainted()) {
            Taint.mergeParameters(a, b, result);
        }
        Taint.mergeRealInstanceClass(a, b, result);
        Taint.mergeTags(a, b, result);
        if (a.constantValue != null && a.constantValue.equals(b.constantValue)) {
            result.constantValue = a.constantValue;
        }
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            result.setDebugInfo("[" + a.getDebugInfo() + "]+[" + b.getDebugInfo() + "]");
        }
        assert (!result.hasParameters() || result.isUnknown());
        if (a.potentialValue != null) {
            result.potentialValue = a.potentialValue;
        } else if (b.potentialValue != null) {
            result.potentialValue = b.potentialValue;
        }
        int sourcesSize = (a.sources != null ? a.sources.size() : 0) + (b.sources != null ? b.sources.size() : 0);
        if (sourcesSize > 0) {
            result.sources = new HashSet<UnknownSource>(sourcesSize);
        }
        if (a.sources != null) {
            result.sources.addAll(a.sources);
        }
        if (b.sources != null) {
            result.sources.addAll(b.sources);
        }
        return result;
    }

    private static void mergeParameters(Taint a, Taint b, Taint result) {
        int parametersSize = (a.parameters != null ? a.parameters.size() : 0) + (b.parameters != null ? b.parameters.size() : 0);
        if (parametersSize == 0) {
            return;
        }
        result.parameters = new HashSet<Integer>(parametersSize);
        if (a.parameters != null) {
            result.parameters.addAll(a.parameters);
        }
        if (b.parameters != null) {
            result.parameters.addAll(b.parameters);
        }
        if (a.hasParameters()) {
            result.nonParametricState = b.hasParameters() ? State.merge(a.nonParametricState, b.nonParametricState) : State.merge(b.state, a.nonParametricState);
        } else if (b.hasParameters()) {
            result.nonParametricState = State.merge(a.state, b.nonParametricState);
        }
    }

    private static void mergeRealInstanceClass(Taint a, Taint b, Taint result) {
        if (a.realInstanceClass != null && b.realInstanceClass != null) {
            try {
                if (a.realInstanceClass.equals((Object)b.realInstanceClass) || b.realInstanceClass.subclassOf(a.realInstanceClass)) {
                    result.realInstanceClass = a.realInstanceClass;
                } else if (a.realInstanceClass.subclassOf(b.realInstanceClass)) {
                    result.realInstanceClass = b.realInstanceClass;
                }
            }
            catch (ClassNotFoundException ex) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
            }
        }
    }

    private static void mergeTags(Taint a, Taint b, Taint result) {
        if (a.isSafe() && b.hasTags()) {
            if (result.tags == null) {
                result.tags = EnumSet.noneOf(Tag.class);
            }
            result.tags.addAll(b.tags);
        } else if (b.isSafe() && a.hasTags()) {
            if (result.tags == null) {
                result.tags = EnumSet.noneOf(Tag.class);
            }
            result.tags.addAll(a.tags);
        } else if (a.hasTags() && b.hasTags()) {
            if (result.tags == null) {
                result.tags = EnumSet.noneOf(Tag.class);
            }
            result.tags.addAll(a.tags);
            result.tags.retainAll(b.tags);
        }
        if (a.isRemovingTags()) {
            if (result.tagsToRemove == null) {
                result.tagsToRemove = EnumSet.noneOf(Tag.class);
            }
            result.tagsToRemove.addAll(a.tagsToRemove);
        }
        if (b.isRemovingTags()) {
            if (result.tagsToRemove == null) {
                result.tagsToRemove = EnumSet.noneOf(Tag.class);
            }
            result.tagsToRemove.addAll(b.tagsToRemove);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Taint)) {
            return false;
        }
        Taint other = (Taint)obj;
        return this.state == other.state && this.variableIndex == other.variableIndex && Objects.equals(this.taintLocations, other.taintLocations) && Objects.equals(this.unknownLocations, other.unknownLocations) && Objects.equals(this.parameters, other.parameters) && this.nonParametricState == other.nonParametricState && Objects.equals(this.realInstanceClass, other.realInstanceClass);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.variableIndex, this.taintLocations, this.unknownLocations, this.parameters, this.nonParametricState, this.realInstanceClass, this.tags, this.constantValue});
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public Taint setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
        return this;
    }

    public Set<UnknownSource> getSources() {
        if (this.sources == null) {
            return Collections.emptySet();
        }
        return this.sources;
    }

    public void addSource(UnknownSource source) {
        if (this.sources == null) {
            this.sources = new HashSet<UnknownSource>();
        }
        this.sources.add(source);
    }

    protected void addAllSources(Set<UnknownSource> sources) {
        if (sources == null) {
            return;
        }
        if (this.sources == null) {
            this.sources = new HashSet<UnknownSource>();
        }
        this.sources.addAll(sources);
    }

    public String toString() {
        assert (this.state != null);
        StringBuilder sb = new StringBuilder(this.state.name().substring(0, 1));
        if (this.hasValidVariableIndex()) {
            sb.append(this.variableIndex);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append(this.parameters);
        }
        assert (this.nonParametricState != null);
        if (this.nonParametricState != State.INVALID) {
            sb.append('(').append(this.nonParametricState.name().substring(0, 1)).append(')');
        }
        if (this.sources != null && this.sources.size() > 0) {
            StringBuilder b = new StringBuilder();
            for (UnknownSource source : this.sources) {
                switch (source.getSourceType()) {
                    case FIELD: {
                        b.append("field[" + source.getSignatureField() + "]");
                        break;
                    }
                    case RETURN: {
                        b.append("method[" + source.getSignatureMethod() + "]");
                        break;
                    }
                    case PARAMETER: {
                        b.append("parameter[" + source.getParameterIndex() + "]");
                    }
                }
            }
            sb.append(" source={").append(b.toString()).append('}');
        }
        if (this.constantValue != null) {
            sb.append(" constant=").append(this.constantValue);
        }
        if (this.potentialValue != null) {
            sb.append(" potential=").append(this.potentialValue);
        }
        if (this.tags != null && this.tags.size() > 0) {
            sb.append(" tags=").append(Arrays.toString(this.tags.toArray()));
        }
        return sb.toString();
    }

    public static enum Tag {
        XSS_SAFE,
        SQL_INJECTION_SAFE,
        COMMAND_INJECTION_SAFE,
        LDAP_INJECTION_SAFE,
        XPATH_INJECTION_SAFE,
        HTTP_POLLUTION_SAFE,
        CR_ENCODED,
        LF_ENCODED,
        QUOTE_ENCODED,
        APOSTROPHE_ENCODED,
        LT_ENCODED,
        SENSITIVE_DATA,
        CUSTOM_INJECTION_SAFE,
        URL_ENCODED,
        PATH_TRAVERSAL_SAFE,
        REDIRECT_SAFE,
        CREDIT_CARD_VARIABLE,
        PASSWORD_VARIABLE,
        HASH_VARIABLE;

    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State TAINTED = new State(false, true, false);
        public static final /* enum */ State UNKNOWN = new State(false, false, true);
        public static final /* enum */ State SAFE = new State(true, false, false);
        public static final /* enum */ State NULL = new State(true, false, false);
        public static final /* enum */ State INVALID = new State(false, false, false);
        private final boolean isSafe;
        private final boolean isTainted;
        private final boolean isUnknown;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(boolean isSafe, boolean isTainted, boolean isUnknown) {
            this.isSafe = isSafe;
            this.isTainted = isTainted;
            this.isUnknown = isUnknown;
        }

        public static State merge(State a, State b) {
            if (a == null || b == null) {
                throw new NullPointerException("use Taint.State." + INVALID.name() + " instead of null");
            }
            if (a == TAINTED || b == TAINTED) {
                return TAINTED;
            }
            if (a == UNKNOWN || b == UNKNOWN) {
                return UNKNOWN;
            }
            if (a == SAFE || b == SAFE) {
                return SAFE;
            }
            if (a == NULL || b == NULL) {
                return NULL;
            }
            assert (a == INVALID && b == INVALID);
            return INVALID;
        }

        static {
            $VALUES = new State[]{TAINTED, UNKNOWN, SAFE, NULL, INVALID};
        }
    }
}

