/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.endpoint;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.Arrays;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SpringMvcEndpointDetector
implements Detector {
    private static final String SPRING_ENDPOINT_TYPE = "SPRING_ENDPOINT";
    private static final List<String> REQUEST_MAPPING_ANNOTATION_TYPES = Arrays.asList("Lorg/springframework/web/bind/annotation/RequestMapping;", "Lorg/springframework/web/bind/annotation/GetMapping;", "Lorg/springframework/web/bind/annotation/PostMapping;", "Lorg/springframework/web/bind/annotation/PutMapping;", "Lorg/springframework/web/bind/annotation/DeleteMapping;", "Lorg/springframework/web/bind/annotation/PatchMapping;");
    private BugReporter bugReporter;

    public SpringMvcEndpointDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        block0: for (Method m : javaClass.getMethods()) {
            for (AnnotationEntry ae : m.getAnnotationEntries()) {
                if (!REQUEST_MAPPING_ANNOTATION_TYPES.contains(ae.getAnnotationType())) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, SPRING_ENDPOINT_TYPE, 3).addClassAndMethod(javaClass, m));
                continue block0;
            }
        }
    }

    public void report() {
    }
}

