/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class PermissiveCORSDetector
extends BasicInjectionDetector {
    private static final String PERMISSIVE_CORS = "PERMISSIVE_CORS";
    private static final String JAVAX_HTTP_SERVLET_RESPONSE_CLASS = "javax.servlet.http.HttpServletResponse";
    private static final String JAKARTA_HTTP_SERVLET_RESPONSE_CLASS = "jakarta.servlet.http.HttpServletResponse";
    private static final String HEADER_KEY = "Access-Control-Allow-Origin";
    private static final InvokeMatcherBuilder SERVLET_RESPONSE_ADD_HEADER_METHOD = InstructionDSL.invokeInstruction().atMethod("addHeader").withArgs("(Ljava/lang/String;Ljava/lang/String;)V");
    private static final InvokeMatcherBuilder JAVAX_SERVLET_RESPONSE_ADD_HEADER_METHOD = SERVLET_RESPONSE_ADD_HEADER_METHOD.atClass("javax.servlet.http.HttpServletResponse");
    private static final InvokeMatcherBuilder JAKARTA_SERVLET_RESPONSE_ADD_HEADER_METHOD = SERVLET_RESPONSE_ADD_HEADER_METHOD.atClass("jakarta.servlet.http.HttpServletResponse");
    private static final InvokeMatcherBuilder SERVLET_RESPONSE_SET_HEADER_METHOD = InstructionDSL.invokeInstruction().atMethod("setHeader").withArgs("(Ljava/lang/String;Ljava/lang/String;)V");
    private static final InvokeMatcherBuilder JAVAX_SERVLET_RESPONSE_SET_HEADER_METHOD = SERVLET_RESPONSE_SET_HEADER_METHOD.atClass("javax.servlet.http.HttpServletResponse");
    private static final InvokeMatcherBuilder JAKARTA_SERVLET_RESPONSE_SET_HEADER_METHOD = SERVLET_RESPONSE_SET_HEADER_METHOD.atClass("jakarta.servlet.http.HttpServletResponse");

    public PermissiveCORSDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        if (this.isServletResponseAddHeaderMethod(invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, PERMISSIVE_CORS);
        }
        if (this.isServletResponseSetHeaderMethod(invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, PERMISSIVE_CORS);
        }
        return InjectionPoint.NONE;
    }

    private boolean isServletResponseSetHeaderMethod(InvokeInstruction invoke, ConstantPoolGen cpg) {
        return JAVAX_SERVLET_RESPONSE_SET_HEADER_METHOD.matches((Instruction)invoke, cpg) || JAKARTA_SERVLET_RESPONSE_SET_HEADER_METHOD.matches((Instruction)invoke, cpg);
    }

    private boolean isServletResponseAddHeaderMethod(InvokeInstruction invoke, ConstantPoolGen cpg) {
        return JAVAX_SERVLET_RESPONSE_ADD_HEADER_METHOD.matches((Instruction)invoke, cpg) || JAKARTA_SERVLET_RESPONSE_ADD_HEADER_METHOD.matches((Instruction)invoke, cpg);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint headerKeyTaint = (Taint)fact.getStackValue(1);
        if (!HEADER_KEY.equalsIgnoreCase(headerKeyTaint.getConstantValue())) {
            return 5;
        }
        Taint headerValueTaint = (Taint)fact.getStackValue(0);
        if (Taint.State.TAINTED.equals((Object)headerValueTaint.getState())) {
            return 1;
        }
        if (Taint.State.UNKNOWN.equals((Object)headerValueTaint.getState())) {
            return 2;
        }
        String headerValue = headerValueTaint.getConstantOrPotentialValue();
        if (headerValue == null) {
            return 5;
        }
        if (headerValue.contains("*") || "null".equalsIgnoreCase(headerValue)) {
            return 1;
        }
        return 5;
    }
}

