/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.jsp;

import com.h3xstream.findsecbugs.common.StackUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class JspIncludeDetector
extends OpcodeStackDetector {
    private static final String JSP_INCLUDE_TYPE = "JSP_INCLUDE";
    private BugReporter bugReporter;

    public JspIncludeDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && ("org/apache/jasper/runtime/JspRuntimeLibrary".equals(this.getClassConstantOperand()) || "org/apache/sling/scripting/jsp/jasper/runtime/JspRuntimeLibrary".equals(this.getClassConstantOperand())) && this.getNameConstantOperand().equals("include") && this.includeMethodSignatureMatches()) {
            if (StackUtils.isVariableString(this.stack.getStackItem(2))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, JSP_INCLUDE_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if (seen == 182 && this.getClassConstantOperand().equals("org/apache/taglibs/standard/tag/rt/core/ImportTag") && this.getNameConstantOperand().equals("setUrl") && this.getSigConstantOperand().equals("(Ljava/lang/String;)V")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, JSP_INCLUDE_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private boolean includeMethodSignatureMatches() {
        return this.getSigConstantOperand().equals("(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Ljava/lang/String;Ljavax/servlet/jsp/JspWriter;Z)V") || this.getSigConstantOperand().equals("(Ljakarta/servlet/ServletRequest;Ljakarta/servlet/ServletResponse;Ljava/lang/String;Ljakarta/servlet/jsp/JspWriter;Z)V");
    }
}

