/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.StringTracer;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class EcbModeDetector
extends OpcodeStackDetector {
    private static final String ECB_MODE_TYPE = "ECB_MODE";
    private static final boolean DEBUG = false;
    private BugReporter bugReporter;

    public EcbModeDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        String cipherValue;
        OpcodeStack.Item item;
        if (seen == 184 && this.getClassConstantOperand().equals("javax/crypto/Cipher") && this.getNameConstantOperand().equals("getInstance") && StringTracer.isConstantString(item = this.stack.getStackItem(this.stack.getStackDepth() - 1)) && ((cipherValue = (String)item.getConstant()).contains("AES/ECB/") || cipherValue.contains("DES/ECB/") || cipherValue.contains("DESede/ECB/"))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, ECB_MODE_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

