/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class WeakTrustManagerDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String WEAK_TRUST_MANAGER_TYPE = "WEAK_TRUST_MANAGER";
    private BugReporter bugReporter;

    public WeakTrustManagerDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        boolean isTrustManager = InterfaceUtils.classImplements(javaClass, "javax.net.ssl.X509TrustManager");
        if (!isTrustManager) {
            return;
        }
        for (Method m : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(m);
            if (!m.getName().equals("checkServerTrusted") && !m.getName().equals("getAcceptedIssuers")) continue;
            boolean invokeInst = false;
            boolean loadField = false;
            for (Instruction inst : methodGen.getInstructionList().getInstructions()) {
                if (inst instanceof InvokeInstruction) {
                    invokeInst = true;
                }
                if (!(inst instanceof GETFIELD)) continue;
                loadField = true;
            }
            if (invokeInst || loadField) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_TRUST_MANAGER_TYPE, 2).addClassAndMethod(javaClass, m));
        }
    }

    public void report() {
    }
}

