/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.endpoint;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;

public class TapestryEndpointDetector
implements Detector {
    private static final String TAPESTRY_ENDPOINT_TYPE = "TAPESTRY_ENDPOINT";
    private BugReporter bugReporter;

    public TapestryEndpointDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!javaClass.getPackageName().contains(".pages")) {
            return;
        }
        if (javaClass.getPackageName().endsWith(".pages")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, TAPESTRY_ENDPOINT_TYPE, 3).addClass(javaClass));
        }
        if (javaClass.getPackageName().contains(".pages")) {
            ConstantPool constants = javaClass.getConstantPool();
            for (Constant c : constants.getConstantPool()) {
                ConstantUtf8 utf8;
                String constantValue;
                if (!(c instanceof ConstantUtf8) || !(constantValue = new String((utf8 = (ConstantUtf8)c).getBytes())).startsWith("Lorg/apache/tapestry5/annotations")) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, TAPESTRY_ENDPOINT_TYPE, 3).addClass(javaClass));
                return;
            }
        }
    }

    public void report() {
    }
}

