/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

public class GoogleApiKeyDetector
implements Detector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private BugReporter bugReporter;

    public GoogleApiKeyDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        ConstantPool ctp = javaClass.getConstantPool();
        boolean keyStringField = false;
        for (Field f : javaClass.getFields()) {
            if (!f.getName().equals("keyString")) continue;
            keyStringField = true;
            break;
        }
        if (!keyStringField) {
            return;
        }
        boolean urlSigner = javaClass.getClassName().contains("UrlSigner");
        if (keyStringField && urlSigner) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, HARD_CODE_PASSWORD_TYPE, 2).addClass(javaClass).addField(new FieldVariable(javaClass.getClassName(), "keyString", "Ljava/lang/String;")));
            return;
        }
        for (Method m : javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(m);
            if (!methodGen.getName().equals("signRequest")) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, HARD_CODE_PASSWORD_TYPE, 2).addClass(javaClass).addField(new FieldVariable(javaClass.getClassName(), "keyString", "")));
        }
    }

    public void report() {
    }
}

