/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.MethodGen;

public class BadHexadecimalConversionDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String BAD_HEXA_CONVERSION_TYPE = "BAD_HEXA_CONVERSION";
    private BugReporter bugReporter;

    public BadHexadecimalConversionDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(m);
            boolean invokeMessageDigest = false;
            boolean invokeToHexString = false;
            ConstantPoolGen cpg = classContext.getConstantPoolGen();
            if (methodGen == null || methodGen.getInstructionList() == null || methodGen.getInstructionList().getInstructions() == null) continue;
            for (Instruction inst : methodGen.getInstructionList().getInstructions()) {
                INVOKEVIRTUAL invoke;
                if (inst instanceof INVOKEVIRTUAL) {
                    invoke = (INVOKEVIRTUAL)inst;
                    if (!"java.security.MessageDigest".equals(invoke.getClassName(cpg)) || !"digest".equals(invoke.getMethodName(cpg))) continue;
                    invokeMessageDigest = true;
                    continue;
                }
                if (!(inst instanceof INVOKESTATIC) || !invokeMessageDigest || !"java.lang.Integer".equals((invoke = (INVOKESTATIC)inst).getClassName(cpg)) || !"toHexString".equals(invoke.getMethodName(cpg))) continue;
                invokeToHexString = true;
            }
            if (!invokeMessageDigest || !invokeToHexString) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BAD_HEXA_CONVERSION_TYPE, 2).addClassAndMethod(javaClass, m));
        }
    }

    public void report() {
    }
}

