/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.SIPUSH;

public class InsufficientKeySizeRsaDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String RSA_KEY_SIZE_TYPE = "RSA_KEY_SIZE";
    private BugReporter bugReporter;

    public InsufficientKeySizeRsaDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException e) {
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(m);
        boolean createRsaKeyGen = false;
        boolean initializeWeakKeyLength = false;
        Location locationWeakness = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            SIPUSH push;
            Number n;
            INVOKESTATIC invoke;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (inst instanceof INVOKESTATIC) {
                String value;
                invoke = (INVOKESTATIC)inst;
                if (!"java.security.KeyPairGenerator".equals(invoke.getClassName(cpg)) || !"getInstance".equals(invoke.getMethodName(cpg)) || (value = ByteCode.getConstantLDC(location.getHandle().getPrev(), cpg, String.class)) == null || !value.toUpperCase().startsWith("RSA")) continue;
                createRsaKeyGen = true;
                continue;
            }
            if (inst instanceof INVOKEVIRTUAL) {
                invoke = (INVOKEVIRTUAL)inst;
                if (!"java.security.KeyPairGenerator".equals(invoke.getClassName(cpg)) || !"initialize".equals(invoke.getMethodName(cpg))) continue;
                n = null;
                if ("(I)V".equals(invoke.getSignature(cpg))) {
                    n = ByteCode.getPushNumber(location.getHandle().getPrev());
                } else if ("(ILjava/security/SecureRandom;)V".equals(invoke.getSignature(cpg)) && (push = ByteCode.getPrevInstruction(location.getHandle(), SIPUSH.class)) != null) {
                    n = push.getValue();
                }
                if (n == null || n.intValue() >= 1024) continue;
                initializeWeakKeyLength = true;
                locationWeakness = location;
                continue;
            }
            if (!(inst instanceof INVOKESPECIAL) || !"java.security.spec.RSAKeyGenParameterSpec".equals((invoke = (INVOKESPECIAL)inst).getClassName(cpg)) || !"<init>".equals(invoke.getMethodName(cpg))) continue;
            n = null;
            if ("(ILjava/math/BigInteger;)V".equals(invoke.getSignature(cpg)) && (push = ByteCode.getPrevInstruction(location.getHandle(), SIPUSH.class)) != null) {
                n = push.getValue();
            }
            if (n == null || n.intValue() >= 1024) continue;
            initializeWeakKeyLength = true;
            locationWeakness = location;
        }
        if (createRsaKeyGen && initializeWeakKeyLength) {
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, RSA_KEY_SIZE_TYPE, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        }
    }

    public void report() {
    }
}

