/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.MethodGen;

public class StaticIvDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String STATIC_IV = "STATIC_IV";
    private BugReporter bugReporter;

    public StaticIvDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException e) {
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(m);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        boolean foundSafeIvGeneration = false;
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            INVOKEVIRTUAL invoke;
            Location location = this.nextLocation(i, cpg);
            Instruction inst = location.getHandle().getInstruction();
            if (inst instanceof INVOKEVIRTUAL && "java.security.SecureRandom".equals((invoke = (INVOKEVIRTUAL)inst).getClassName(cpg)) && "nextBytes".equals(invoke.getMethodName(cpg))) {
                foundSafeIvGeneration = true;
            }
            if (foundSafeIvGeneration || !(inst instanceof INVOKESPECIAL) || !"javax.crypto.spec.IvParameterSpec".equals((invoke = (INVOKESPECIAL)inst).getClassName(cpg)) || !"<init>".equals(invoke.getMethodName(cpg))) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, STATIC_IV, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
        }
    }

    private Location nextLocation(Iterator<Location> i, ConstantPoolGen cpg) {
        Location loc = i.next();
        return loc;
    }

    public void report() {
    }
}

