/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.jsp;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.StoreInstruction;

public class JspXssDetector
implements Detector {
    private static final String XSS_JSP_PRINT = "XSS_JSP_PRINT";
    private static final String XSS_SERVLET = "XSS_SERVLET";
    private static final boolean DEBUG = false;
    private BugReporter bugReporter;

    public JspXssDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException e) {
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(m);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        HashSet<Integer> taintedLocals = new HashSet<Integer>();
        Iterator i = cfg.locationIterator();
        block0: while (i.hasNext()) {
            StoreInstruction storeIns;
            int storeDestination;
            Location location = this.nextLocation(i, cpg);
            Instruction inst = location.getHandle().getInstruction();
            if (inst instanceof InvokeInstruction) {
                Location potentialStore;
                InvokeInstruction invoke = (InvokeInstruction)inst;
                if (!"javax.servlet.http.HttpServletRequest".equals(invoke.getClassName(cpg)) || !"getAttribute".equals(invoke.getMethodName(cpg)) && !"getParameter".equals(invoke.getMethodName(cpg))) continue;
                while ((potentialStore = this.nextLocation(i, cpg)) != null) {
                    Instruction potentialStoreIns = potentialStore.getHandle().getInstruction();
                    if (potentialStoreIns instanceof CHECKCAST) continue;
                    if (!(potentialStoreIns instanceof StoreInstruction)) continue block0;
                    StoreInstruction taintedStore = (StoreInstruction)potentialStoreIns;
                    taintedLocals.add(taintedStore.getIndex());
                    continue block0;
                }
                continue;
            }
            if (inst instanceof LoadInstruction) {
                LoadInstruction loadIns = (LoadInstruction)inst;
                if (!taintedLocals.contains(loadIns.getIndex())) continue;
                Location locationAfterLoad = (Location)i.next();
                Instruction locationAfterLoadIns = locationAfterLoad.getHandle().getInstruction();
                if (locationAfterLoadIns instanceof InvokeInstruction) {
                    JavaClass clz;
                    InvokeInstruction invoke = (InvokeInstruction)locationAfterLoadIns;
                    if ("javax.servlet.jsp.JspWriter".equals(invoke.getClassName(cpg)) && "print".equals(invoke.getMethodName(cpg))) {
                        clz = classContext.getJavaClass();
                        this.bugReporter.reportBug(new BugInstance((Detector)this, XSS_JSP_PRINT, 1).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationAfterLoad));
                    } else if ("java.io.PrintWriter".equals(invoke.getClassName(cpg)) && "write".equals(invoke.getMethodName(cpg))) {
                        clz = classContext.getJavaClass();
                        this.bugReporter.reportBug(new BugInstance((Detector)this, XSS_SERVLET, 1).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationAfterLoad));
                    }
                } else if (locationAfterLoadIns instanceof CHECKCAST) {
                    locationAfterLoadIns = ((Location)i.next()).getHandle().getInstruction();
                }
                if (!(locationAfterLoadIns instanceof StoreInstruction)) continue;
                StoreInstruction relocateTainted = (StoreInstruction)locationAfterLoadIns;
                taintedLocals.add(relocateTainted.getIndex());
                continue;
            }
            if (!(inst instanceof StoreInstruction) || !taintedLocals.contains(storeDestination = (storeIns = (StoreInstruction)inst).getIndex())) continue;
            taintedLocals.remove(storeDestination);
        }
    }

    private Location nextLocation(Iterator<Location> i, ConstantPoolGen cpg) {
        Location loc = i.next();
        return loc;
    }

    public void report() {
    }
}

