/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xxe;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.MethodGen;

public class SaxParserXxeDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = false;
    private static final String XXE_TYPE = "XXE";
    private BugReporter bugReporter;

    public SaxParserXxeDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen != 182 && seen != 185) {
            return;
        }
        String fullClassName = this.getClassConstantOperand();
        String method = this.getNameConstantOperand();
        if (seen == 182 && fullClassName.equals("javax/xml/parsers/SAXParser") && method.equals("parse") || seen == 185 && fullClassName.equals("org/xml/sax/XMLReader") && method.equals("parse") || seen == 182 && this.getClassConstantOperand().equals("javax/xml/parsers/DocumentBuilder") && method.equals("parse")) {
            JavaClass javaClass = this.getThisClass();
            if (InterfaceUtils.classImplements(javaClass, "java.security.PrivilegedExceptionAction")) {
                return;
            }
            ClassContext classCtx = this.getClassContext();
            ConstantPoolGen cpg = classCtx.getConstantPoolGen();
            MethodGen methodGen = classCtx.getMethodGen(this.getMethod());
            for (Instruction inst : methodGen.getInstructionList().getInstructions()) {
                INVOKEINTERFACE invoke;
                if (!(inst instanceof INVOKEINTERFACE) || !"setEntityResolver".equals((invoke = (INVOKEINTERFACE)inst).getMethodName(cpg))) continue;
                return;
            }
            String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(47));
            this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(simpleClassName + "." + method + "(...)"));
        }
    }
}

