/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class StrutsValidatorFormDetector
implements Detector {
    private static final String STRUTS_FORM_VALIDATION_TYPE = "STRUTS_FORM_VALIDATION";
    private BugReporter bugReporter;

    public StrutsValidatorFormDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        boolean isActionForm = InterfaceUtils.classExtends(javaClass, "org.apache.struts.action.ActionForm");
        boolean isValidatorForm = InterfaceUtils.classExtends(javaClass, "org.apache.struts.validator.ValidatorForm");
        if (isActionForm && !isValidatorForm) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, STRUTS_FORM_VALIDATION_TYPE, 2).addClass(javaClass).addString("ActionForm"));
            return;
        }
        if (!isValidatorForm) {
            return;
        }
        String expectedSig = "(Lorg/apache/struts/action/ActionMapping;Ljavax/servlet/http/HttpServletRequest;)Lorg/apache/struts/action/ActionErrors;";
        boolean validateMethodFound = false;
        for (Method m : javaClass.getMethods()) {
            if (!"validate".equals(m.getName()) || !"(Lorg/apache/struts/action/ActionMapping;Ljavax/servlet/http/HttpServletRequest;)Lorg/apache/struts/action/ActionErrors;".equals(m.getSignature())) continue;
            validateMethodFound = true;
        }
        if (!validateMethodFound) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, STRUTS_FORM_VALIDATION_TYPE, 3).addClass(javaClass).addString("ValidatorForm"));
        }
    }

    public void report() {
    }
}

