/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.common;

import edu.umd.cs.findbugs.OpcodeStack;

public class StringTracer {
    public static boolean isConstantString(OpcodeStack.Item item) {
        return !StringTracer.isVariableString(item);
    }

    public static boolean isVariableString(OpcodeStack.Item item) {
        String value = (String)item.getConstant();
        return value == null;
    }

    public static boolean hasVariableString(OpcodeStack stack) {
        boolean hasStringParam = false;
        for (int i = 0; i < stack.getStackDepth(); ++i) {
            OpcodeStack.Item item = stack.getStackItem(i);
            if (!"[Ljava/lang/String;".equals(item.getSignature())) continue;
            hasStringParam = true;
            if (!StringTracer.isVariableString(item)) continue;
            return true;
        }
        return !hasStringParam;
    }
}

