/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xxe;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.LDC;

public class SaxParserXxeDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = false;
    private static final String XXE_SAX_PARSER_TYPE = "XXE_SAXPARSER";
    private static final String XXE_XML_READER_TYPE = "XXE_XMLREADER";
    private static final String XXE_DOCUMENT_TYPE = "XXE_DOCUMENT";
    private static final String FEATURE_DISALLOW_DTD = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
    private static final String FEATURE_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private BugReporter bugReporter;

    public SaxParserXxeDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen != 182 && seen != 185) {
            return;
        }
        String fullClassName = this.getClassConstantOperand();
        String method = this.getNameConstantOperand();
        if (seen == 182 && fullClassName.equals("javax/xml/parsers/SAXParser") && method.equals("parse") || seen == 185 && fullClassName.equals("org/xml/sax/XMLReader") && method.equals("parse") || seen == 182 && this.getClassConstantOperand().equals("javax/xml/parsers/DocumentBuilder") && method.equals("parse")) {
            JavaClass javaClass = this.getThisClass();
            if (InterfaceUtils.classImplements(javaClass, "java.security.PrivilegedExceptionAction")) {
                return;
            }
            ClassContext classCtx = this.getClassContext();
            ConstantPoolGen cpg = classCtx.getConstantPoolGen();
            CFG cfg = null;
            try {
                cfg = classCtx.getCFG(this.getMethod());
            }
            catch (CFGBuilderException e) {
                throw new RuntimeException(e);
            }
            boolean hasSetXIncludeAware = false;
            boolean hasExpandEntityReferences = !this.getClassConstantOperand().equals("javax/xml/parsers/DocumentBuilder");
            boolean hasFeatureGeneralEntities = false;
            boolean hasFeatureExternalEntities = false;
            Iterator i = cfg.locationIterator();
            while (i.hasNext()) {
                ICONST boolConst;
                INVOKEINTERFACE invoke;
                Location location = (Location)i.next();
                Instruction inst = location.getHandle().getInstruction();
                if (inst instanceof INVOKEINTERFACE && "setEntityResolver".equals((invoke = (INVOKEINTERFACE)inst).getMethodName(cpg))) {
                    return;
                }
                if (!(inst instanceof INVOKEVIRTUAL)) continue;
                invoke = (INVOKEVIRTUAL)inst;
                if ("setFeature".equals(invoke.getMethodName(cpg))) {
                    LDC loadConst = ByteCode.getPrevInstruction(location.getHandle(), LDC.class);
                    if (loadConst == null) continue;
                    if (FEATURE_DISALLOW_DTD.equals(loadConst.getValue(cpg))) {
                        return;
                    }
                    if (FEATURE_SECURE_PROCESSING.equals(loadConst.getValue(cpg))) {
                        return;
                    }
                    if (FEATURE_GENERAL_ENTITIES.equals(loadConst.getValue(cpg))) {
                        hasFeatureGeneralEntities = true;
                        continue;
                    }
                    if (!FEATURE_EXTERNAL_ENTITIES.equals(loadConst.getValue(cpg))) continue;
                    hasFeatureExternalEntities = true;
                    continue;
                }
                if ("setXIncludeAware".equals(invoke.getMethodName(cpg))) {
                    boolConst = ByteCode.getPrevInstruction(location.getHandle(), ICONST.class);
                    if (boolConst == null || !boolConst.getValue().equals(0)) continue;
                    hasSetXIncludeAware = true;
                    continue;
                }
                if (!"setExpandEntityReferences".equals(invoke.getMethodName(cpg)) || (boolConst = ByteCode.getPrevInstruction(location.getHandle(), ICONST.class)) == null || !boolConst.getValue().equals(0)) continue;
                hasExpandEntityReferences = true;
            }
            if (hasFeatureExternalEntities && hasFeatureGeneralEntities && hasSetXIncludeAware && hasExpandEntityReferences) {
                return;
            }
            String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(47));
            if (fullClassName.equals("javax/xml/parsers/SAXParser")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_SAX_PARSER_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(simpleClassName + "." + method + "(...)"));
            } else if (fullClassName.equals("org/xml/sax/XMLReader")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_XML_READER_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(simpleClassName + "." + method + "(...)"));
            } else if (fullClassName.equals("javax/xml/parsers/DocumentBuilder")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_DOCUMENT_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(simpleClassName + "." + method + "(...)"));
            }
        }
    }
}

