/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.StringTracer;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class CommandInjectionDetector
extends OpcodeStackDetector {
    private static final String COMMAND_INJECTION_TYPE = "COMMAND_INJECTION";
    private BugReporter bugReporter;

    public CommandInjectionDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getClassConstantOperand().equals("java/lang/Runtime") && this.getNameConstantOperand().equals("exec")) {
            if (StringTracer.isVariableString(this.stack.getStackItem(0))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, COMMAND_INJECTION_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("Runtime.exec(...)"));
            }
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/ProcessBuilder") && this.getNameConstantOperand().equals("command") && StringTracer.hasVariableString(this.stack)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, COMMAND_INJECTION_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("ProcessBuilder.command(...)"));
        }
    }
}

