/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.common;

import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.SIPUSH;

public class ByteCode {
    public static void printOpCode(Instruction ins, ConstantPoolGen cpg) {
        if (ins instanceof InvokeInstruction) {
            InvokeInstruction invokeIns = (InvokeInstruction)ins;
            System.out.println(ins.getClass().getSimpleName() + " " + invokeIns.getClassName(cpg).replaceAll("\\.", "/") + "." + invokeIns.getMethodName(cpg) + " (" + invokeIns.getSignature(cpg) + ")");
        } else {
            System.out.println(ins.getClass().getSimpleName() + " " + ins.toString());
        }
    }

    public static <T> T getConstantLDC(InstructionHandle h, ConstantPoolGen cpg, Class<T> clazz) {
        LDC ldcCipher;
        Object val;
        Instruction prevIns = h.getInstruction();
        if (prevIns instanceof LDC && (val = (ldcCipher = (LDC)prevIns).getValue(cpg)).getClass().equals(clazz)) {
            return clazz.cast(val);
        }
        return null;
    }

    public static Number getPushNumber(InstructionHandle h) {
        Instruction prevIns = h.getInstruction();
        if (prevIns instanceof BIPUSH) {
            BIPUSH ldcCipher = (BIPUSH)prevIns;
            return ldcCipher.getValue();
        }
        if (prevIns instanceof SIPUSH) {
            SIPUSH ldcCipher = (SIPUSH)prevIns;
            return ldcCipher.getValue();
        }
        return null;
    }

    public static <T> T getPrevInstruction(InstructionHandle startHandle, Class<T> clazz) {
        InstructionHandle curHandle = startHandle;
        while (curHandle != null) {
            if ((curHandle = curHandle.getPrev()) == null || !clazz.isInstance(curHandle.getInstruction())) continue;
            return clazz.cast(curHandle.getInstruction());
        }
        return null;
    }
}

