/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.StackUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.List;

public class CipherWithNoIntegrityDetector
extends OpcodeStackDetector {
    private static final String ECB_MODE_TYPE = "ECB_MODE";
    private static final String PADDING_ORACLE_TYPE = "PADDING_ORACLE";
    private static final String CIPHER_INTEGRITY_TYPE = "CIPHER_INTEGRITY";
    private static final boolean DEBUG = false;
    private static final List<String> SECURE_CIPHER_MODES = Arrays.asList("CCM", "CWC", "OCB", "EAX", "GCM");
    private BugReporter bugReporter;

    public CipherWithNoIntegrityDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if (seen == 184 && this.getClassConstantOperand().equals("javax/crypto/Cipher") && this.getNameConstantOperand().equals("getInstance") && StackUtils.isConstantString(item = this.stack.getStackItem(this.stack.getStackDepth() - 1))) {
            String cipherMode;
            String[] cipherDefinition;
            String cipherValue = (String)item.getConstant();
            if (cipherValue.contains("AES/ECB/") || cipherValue.contains("DES/ECB/") || cipherValue.contains("DESede/ECB/")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, ECB_MODE_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (cipherValue.contains("/CBC/PKCS5Padding")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, PADDING_ORACLE_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if ((cipherDefinition = cipherValue.split("/")).length > 1 && !cipherValue.startsWith("RSA/") && !SECURE_CIPHER_MODES.contains(cipherMode = cipherDefinition[1])) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, CIPHER_INTEGRITY_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }
}

