/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.ldap;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class JndiLdapInjectionSource
implements InjectionSource {
    private static final String LDAP_INJECTION_TYPE = "LDAP_INJECTION";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            String utf8String;
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8) || !(utf8String = ((ConstantUtf8)cnt).getBytes()).equals("javax/naming/directory/InitialDirContext")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKEVIRTUAL) {
            String methodName = ins.getMethodName(cpg);
            String methodSignature = ins.getSignature(cpg);
            String className = ins.getClassName(cpg);
            if (className.equals("javax.naming.directory.InitialDirContext") && methodName.equals("search") && methodSignature.equals("(Ljava/lang/String;Ljava/lang/String;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;")) {
                return new InjectionPoint(new int[]{1, 2}, LDAP_INJECTION_TYPE);
            }
        }
        return InjectionPoint.NONE;
    }
}

