/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.script;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class ScriptEngineSource
implements InjectionSource {
    private static final String SCRIPT_ENGINE_INJECTION_TYPE = "SCRIPT_ENGINE_INJECTION";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            String utf8String;
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8) || !(utf8String = ((ConstantUtf8)cnt).getBytes()).equals("javax/script/ScriptEngine")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKEINTERFACE) {
            String methodName = ins.getMethodName(cpg);
            String methodSignature = ins.getSignature(cpg);
            String className = ins.getClassName(cpg);
            if (className.equals("javax.script.ScriptEngine") && methodName.equals("eval") && methodSignature.equals("(Ljava/lang/String;)Ljava/lang/Object;")) {
                return new InjectionPoint(new int[]{0}, SCRIPT_ENGINE_INJECTION_TYPE);
            }
        }
        return InjectionPoint.NONE;
    }
}

