/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.sql;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class HibernateInjectionSource
implements InjectionSource {
    protected static final String SQL_INJECTION_TYPE = "SQL_INJECTION_HIBERNATE";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            String utf8String;
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8) || !(utf8String = ((ConstantUtf8)cnt).getBytes()).equals("org/hibernate/criterion/Restrictions") && !utf8String.equals("org/hibernate/Session")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKESTATIC || ins instanceof INVOKEINTERFACE) {
            String methodName = ins.getMethodName(cpg);
            String methodSignature = ins.getSignature(cpg);
            String className = ins.getClassName(cpg);
            if (ins instanceof INVOKESTATIC && className.equals("org.hibernate.criterion.Restrictions") && methodName.equals("sqlRestriction")) {
                if (methodSignature.equals("(Ljava/lang/String;)Lorg/hibernate/criterion/Criterion;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/lang/Object;Lorg/hibernate/type/Type;)Lorg/hibernate/criterion/Criterion;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[Lorg/hibernate/type/Type;)Lorg/hibernate/criterion/Criterion;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else {
                if (ins instanceof INVOKEINTERFACE && className.equals("org.hibernate.Session") && methodName.equals("createQuery") && methodSignature.equals("(Ljava/lang/String;)Lorg/hibernate/Query;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (ins instanceof INVOKEINTERFACE && className.equals("org.hibernate.Session") && methodName.equals("createSQLQuery") && methodSignature.equals("(Ljava/lang/String;)Lorg/hibernate/SQLQuery;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
            }
        }
        return InjectionPoint.NONE;
    }
}

