/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;

public abstract class InjectionDetector
implements Detector {
    private BugReporter bugReporter;

    protected InjectionDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        Method[] methodList = javaClass.getMethods();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        ArrayList<InjectionSource> selectedSources = new ArrayList<InjectionSource>();
        for (InjectionSource injectionSource : this.getInjectionSource()) {
            if (!injectionSource.isCandidate(cpg)) continue;
            selectedSources.add(injectionSource);
        }
        if (selectedSources.size() > 0) {
            for (InjectionSource injectionSource : methodList) {
                MethodGen methodGen = classContext.getMethodGen((Method)injectionSource);
                if (methodGen == null) continue;
                try {
                    this.analyzeMethod(classContext, (Method)injectionSource, selectedSources);
                }
                catch (DataflowAnalysisException e) {
                }
                catch (CFGBuilderException e) {
                    // empty catch block
                }
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method, List<InjectionSource> selectedSources) throws DataflowAnalysisException, CFGBuilderException {
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        ConstantPoolGen cpg = methodGen.getConstantPool();
        CFG cfg = classContext.getCFG(method);
        ConstantDataflow dataflow = classContext.getConstantDataflow(method);
        Iterator i = cfg.locationIterator();
        block0: while (i.hasNext()) {
            InjectionSource source;
            Location location = (Location)i.next();
            InstructionHandle insHandle = location.getHandle();
            Instruction ins = insHandle.getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction invoke = (InvokeInstruction)ins;
            InjectionPoint injectionPoint = null;
            Iterator<InjectionSource> i$ = selectedSources.iterator();
            while (i$.hasNext() && (injectionPoint = (source = i$.next()).getInjectableParameters(invoke, cpg, insHandle)) == InjectionPoint.NONE) {
            }
            if (injectionPoint == InjectionPoint.NONE) continue;
            ConstantFrame frame = (ConstantFrame)dataflow.getFactAtLocation(location);
            for (int arg : injectionPoint.getInjectableArguments()) {
                Constant value = (Constant)frame.getStackValue(arg);
                if (value != null && value.isConstantString()) continue;
                Location prev = this.getPreviousLocation(cfg, location, true);
                for (int a = 0; a < arg; ++a) {
                    prev = this.getPreviousLocation(cfg, prev, true);
                }
                if (prev == null || this.isSafeValue(prev, cpg, cfg)) continue;
                BugInstance bugInstance = new BugInstance((Detector)this, injectionPoint.getBugType(), 1).addClass(javaClass).addMethod(javaClass, method).addSourceLine(classContext, method, location);
                if (injectionPoint.getInjectableMethod() != null) {
                    bugInstance.addString(injectionPoint.getInjectableMethod());
                }
                this.bugReporter.reportBug(bugInstance);
                continue block0;
            }
        }
    }

    private InstructionHandle getPreviousInstruction(InstructionHandle handle, boolean skipNops) {
        while (handle.getPrev() != null) {
            handle = handle.getPrev();
            Instruction prevIns = handle.getInstruction();
            if (skipNops && prevIns instanceof NOP) continue;
            return handle;
        }
        return null;
    }

    private Location getPreviousLocation(CFG cfg, Location startLocation, boolean skipNops) {
        InstructionHandle lastInstruction;
        Location loc = startLocation;
        InstructionHandle prev = this.getPreviousInstruction(loc.getHandle(), skipNops);
        if (prev != null) {
            return new Location(prev, loc.getBasicBlock());
        }
        BasicBlock block = loc.getBasicBlock();
        do {
            if ((block = cfg.getPredecessorWithEdgeType(block, 0)) != null) continue;
            return null;
        } while ((lastInstruction = block.getLastInstruction()) == null);
        return new Location(lastInstruction, block);
    }

    private boolean isSafeValue(Location location, ConstantPoolGen cpg, CFG cfg) throws CFGBuilderException {
        GETSTATIC getStatic;
        Location prev2;
        Location prev;
        String methodName;
        Instruction prevIns = location.getHandle().getInstruction();
        if (prevIns instanceof LDC || prevIns instanceof GETSTATIC) {
            return true;
        }
        if (prevIns instanceof InvokeInstruction && (methodName = ((InvokeInstruction)prevIns).getMethodName(cpg)).startsWith("to") && methodName.endsWith("String") && methodName.length() > 8) {
            return true;
        }
        return prevIns instanceof AALOAD && (prev = this.getPreviousLocation(cfg, location, true)) != null && (prev2 = this.getPreviousLocation(cfg, prev, true)) != null && prev2.getHandle().getInstruction() instanceof GETSTATIC && (getStatic = (GETSTATIC)prev2.getHandle().getInstruction()).getSignature(cpg).equals("[Ljava/lang/String;");
    }

    public void report() {
    }

    public abstract InjectionSource[] getInjectionSource();
}

