/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class ConstantPasswordDetector
extends OpcodeStackDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private final BugReporter bugReporter;
    private boolean staticInitializerSeen = false;
    private static final String PASSWORD_METHODS_DIR = "password-methods";
    private static final String CHAR_ARRAY_METHODS_FILENAME = "password-methods-char.txt";
    private static final String BYTE_ARRAY_METHODS_FILENAME = "password-methods-byte.txt";
    private static final String BIG_INTEGER_METHODS_FILENAME = "password-methods-biginteger.txt";
    private static final String STRING_METHODS_FILENAME = "password-methods-string.txt";
    private static final String PASSWORD_NAMES = ".*(pass|pwd|psw|secret|key|cipher|crypt|des|aes).*";
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(".*(pass|pwd|psw|secret|key|cipher|crypt|des|aes).*", 2);
    private boolean constCharArraySeenLocally = false;
    private boolean charArrayFieldLoaded = false;
    private boolean constCharArrayFieldDefined = false;
    private Set<String> charMethods = new HashSet<String>();
    private boolean constByteArraySeenLocally = false;
    private boolean byteArrayFieldLoaded = false;
    private boolean constByteArrayFieldDefined = false;
    private final Set<String> byteMethods = new HashSet<String>();
    private static final int MIN_CONST_ARRAY_LENGTH = 4;
    private int constArrayState = -1;
    private boolean isByteArray = false;
    private boolean constBigIntegerSeenLocally = false;
    private boolean bigIntegerFieldLoaded = false;
    private boolean constBigIntegerFieldDefined = false;
    private final Set<String> bigIntegerMethods = new HashSet<String>();
    private final Map<String, Integer> stringMethods = new HashMap<String, Integer>();

    public ConstantPasswordDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.loadResources();
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot load resources", ex);
        }
    }

    public void visit(JavaClass javaClass) {
        Method[] methods;
        this.staticInitializerSeen = false;
        this.constCharArrayFieldDefined = false;
        this.constByteArrayFieldDefined = false;
        this.constBigIntegerFieldDefined = false;
        for (Method method : methods = javaClass.getMethods()) {
            if (!method.getName().equals("<clinit>")) continue;
            this.doVisitMethod(method);
            this.staticInitializerSeen = true;
            break;
        }
    }

    public void visit(Method method) {
        this.constCharArraySeenLocally = false;
        this.charArrayFieldLoaded = false;
        this.constByteArraySeenLocally = false;
        this.byteArrayFieldLoaded = false;
        this.constArrayState = -1;
        this.constBigIntegerSeenLocally = false;
        this.bigIntegerFieldLoaded = false;
    }

    public void sawOpcode(int seen) {
        if (this.getMethodName().equals("<clinit>") && this.staticInitializerSeen) {
            return;
        }
        this.checkArrayDeclaration(seen);
        this.checkFieldLoaded(seen);
        if ((seen == 181 || seen == 179) && "Ljava/math/BigInteger;".equals(this.getSigConstantOperand()) && this.constBigIntegerSeenLocally) {
            this.constBigIntegerFieldDefined = true;
        }
        if (seen < 182 || seen > 185) {
            return;
        }
        String calledMethod = this.getCalledMethodName();
        this.checkArrayConversion(calledMethod);
        this.checkBigIntegerDeclaration(calledMethod);
        this.checkMethods(calledMethod);
    }

    private void checkArrayDeclaration(int seen) {
        if (this.constArrayState == -1) {
            if (seen == 188) {
                this.constArrayState = 0;
            }
            return;
        }
        if (this.constArrayState >= 4) {
            this.setArraySeen(seen);
        }
        if (seen == 85) {
            this.isByteArray = false;
            ++this.constArrayState;
            return;
        }
        if (seen == 84) {
            this.isByteArray = true;
            ++this.constArrayState;
            return;
        }
        if (seen != 89 && seen != 16 && seen != 17 && seen > 8) {
            this.constArrayState = -1;
        }
    }

    private void setArraySeen(int seen) {
        if (this.isByteArray) {
            this.constByteArraySeenLocally = true;
        } else {
            this.constCharArraySeenLocally = true;
        }
        if (seen == 181 || seen == 179) {
            String fieldName = this.getNameConstantOperand();
            if (PASSWORD_PATTERN.matcher(fieldName).matches()) {
                this.reportBug(fieldName, 2);
            }
            this.constArrayState = -1;
            if (this.isByteArray) {
                this.constByteArrayFieldDefined = true;
            } else {
                this.constCharArrayFieldDefined = true;
            }
        }
    }

    private void checkFieldLoaded(int seen) {
        if (seen != 178 && seen != 180) {
            return;
        }
        if (!this.getClassName().equals(this.getClassConstantOperand())) {
            return;
        }
        String sig = this.getSigConstantOperand();
        if ("[C".equals(sig)) {
            this.charArrayFieldLoaded = true;
        } else if ("[B".equals(sig)) {
            this.byteArrayFieldLoaded = true;
        } else if ("Ljava/math/BigInteger;".equals(sig)) {
            this.bigIntegerFieldLoaded = true;
        }
    }

    private void checkArrayConversion(String currentMethod) {
        String methodToCharArray = "java/lang/String.toCharArray()[C";
        if ("java/lang/String.toCharArray()[C".equals(currentMethod) && this.hasConstantOnStack(0)) {
            this.constCharArraySeenLocally = true;
        }
        if (currentMethod.startsWith("java/lang/String.getBytes(") && this.hasConstantOnStack(0)) {
            this.constByteArraySeenLocally = true;
        }
    }

    private void checkBigIntegerDeclaration(String currentMethod) {
        String constructorString = "java/math/BigInteger.<init>(Ljava/lang/String;)V";
        String constructorStringRadix = "java/math/BigInteger.<init>(Ljava/lang/String;I)V";
        if ("java/math/BigInteger.<init>(Ljava/lang/String;)V".equals(currentMethod) && this.hasConstantOnStack(0) || "java/math/BigInteger.<init>(Ljava/lang/String;I)V".equals(currentMethod) && this.hasConstantOnStack(1)) {
            this.constBigIntegerSeenLocally = true;
        }
        if (("java/math/BigInteger.<init>([B)V".equals(currentMethod) || "java/math/BigInteger.<init>(I[B)V".equals(currentMethod)) && this.hasConstByteArray()) {
            this.constBigIntegerSeenLocally = true;
        }
    }

    private void checkMethods(String calledMethod) {
        if (this.hasConstCharArray()) {
            this.reportIfInSet(calledMethod, this.charMethods);
        }
        if (this.hasConstByteArray()) {
            this.reportIfInSet(calledMethod, this.byteMethods);
        }
        if (this.hasBigInteger()) {
            this.reportIfInSet(calledMethod, this.bigIntegerMethods);
        }
        if (this.stringMethods.containsKey(calledMethod) && this.hasConstantOnStack(this.stringMethods.get(calledMethod))) {
            this.reportBug(calledMethod, 1);
        }
    }

    private boolean hasConstCharArray() {
        return this.constCharArraySeenLocally || this.charArrayFieldLoaded && this.constCharArrayFieldDefined;
    }

    private boolean hasConstByteArray() {
        return this.constByteArraySeenLocally || this.byteArrayFieldLoaded && this.constByteArrayFieldDefined;
    }

    private boolean hasBigInteger() {
        return this.constBigIntegerSeenLocally || this.bigIntegerFieldLoaded && this.constBigIntegerFieldDefined;
    }

    private boolean hasConstantOnStack(int position) {
        return this.stack.getStackItem(position).getConstant() != null;
    }

    private String getCalledMethodName() {
        String methodNameWithSignature = this.getNameConstantOperand() + this.getSigConstantOperand();
        return this.getClassConstantOperand() + "." + methodNameWithSignature;
    }

    private void reportIfInSet(String method, Set<String> set) {
        if (set.contains(method)) {
            this.reportBug(method, 1);
        }
    }

    private void reportBug(String value, int priority) {
        this.bugReporter.reportBug(new BugInstance((Detector)this, HARD_CODE_PASSWORD_TYPE, priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(value));
    }

    private void loadResources() throws IOException {
        this.loadCollection(CHAR_ARRAY_METHODS_FILENAME, this.charMethods);
        this.loadCollection(BYTE_ARRAY_METHODS_FILENAME, this.byteMethods);
        this.loadCollection(BIG_INTEGER_METHODS_FILENAME, this.bigIntegerMethods);
        this.loadMap(STRING_METHODS_FILENAME, this.stringMethods, "#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCollection(String filename, Collection<String> collection) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = this.getReader(filename);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                collection.add(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMap(String filename, Map<String, Integer> map, String separator) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = this.getReader(filename);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] tuple = line.split(separator);
                map.put(tuple[0], Integer.parseInt(tuple[1]));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private BufferedReader getReader(String filename) {
        String path = "password-methods/" + filename;
        return new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path)));
    }
}

