/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import edu.umd.cs.findbugs.ba.Location;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Taint {
    private State state;
    private static final int INVALID_INDEX = -1;
    private int localVariableIndex;
    private final Set<Location> taintLocations;
    private final Set<Location> possibleTaintLocations;

    public Taint(State state) {
        if (state == null) {
            throw new NullPointerException("state not set");
        }
        this.state = state;
        this.localVariableIndex = -1;
        this.possibleTaintLocations = new HashSet<Location>();
        this.taintLocations = new HashSet<Location>();
    }

    public Taint(Taint taint) {
        if (taint == null) {
            throw new NullPointerException("taint is null");
        }
        this.state = taint.state;
        this.localVariableIndex = taint.localVariableIndex;
        this.taintLocations = new HashSet<Location>(taint.taintLocations);
        this.possibleTaintLocations = new HashSet<Location>(taint.possibleTaintLocations);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.state = state;
    }

    public int getLocalVariableIndex() {
        if (this.localVariableIndex == -1) {
            throw new IllegalStateException("index not set or has been invalidated");
        }
        return this.localVariableIndex;
    }

    public boolean hasValidLocalVariableIndex() {
        return this.localVariableIndex != -1;
    }

    public void setLocalVariableIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index");
        }
        this.localVariableIndex = index;
    }

    public void invalidateLocalVariableIndex() {
        this.localVariableIndex = -1;
    }

    public void addTaintLocation(Location location, boolean isKnownTaintSource) {
        if (isKnownTaintSource) {
            this.taintLocations.add(location);
        } else {
            this.possibleTaintLocations.add(location);
        }
    }

    public Set<Location> getTaintedLocations() {
        return Collections.unmodifiableSet(this.taintLocations);
    }

    public boolean hasTaintedLocations() {
        return !this.taintLocations.isEmpty();
    }

    public Set<Location> getPossibleTaintedLocations() {
        return Collections.unmodifiableSet(this.possibleTaintLocations);
    }

    public boolean isSafe() {
        return this.state.isSafe;
    }

    public boolean isTainted() {
        return this.state.isTainted;
    }

    public static Taint merge(Taint a, Taint b) {
        Taint result = new Taint(State.merge(a.getState(), b.getState()));
        if (a.hasValidLocalVariableIndex() && b.hasValidLocalVariableIndex() && a.getLocalVariableIndex() == b.getLocalVariableIndex()) {
            result.setLocalVariableIndex(a.getLocalVariableIndex());
        }
        result.taintLocations.addAll(a.getTaintedLocations());
        result.taintLocations.addAll(b.getTaintedLocations());
        result.possibleTaintLocations.addAll(a.getPossibleTaintedLocations());
        result.possibleTaintLocations.addAll(b.getPossibleTaintedLocations());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Taint)) {
            return false;
        }
        Taint other = (Taint)obj;
        return this.state == other.state;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    public String toString() {
        String str = this.state.name().substring(0, 1);
        if (this.hasValidLocalVariableIndex()) {
            str = str + this.localVariableIndex;
        }
        return str;
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State SAFE = new State(true, false);
        public static final /* enum */ State NULL = new State(true, false);
        public static final /* enum */ State UNKNOWN = new State(false, false);
        public static final /* enum */ State TAINTED = new State(false, true);
        private final boolean isSafe;
        private final boolean isTainted;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(boolean isSafe, boolean isTainted) {
            this.isSafe = isSafe;
            this.isTainted = isTainted;
        }

        public static State merge(State a, State b) {
            if (a == null || b == null) {
                throw new NullPointerException("use UKNOWN instead of null");
            }
            if (a == TAINTED || b == TAINTED) {
                return TAINTED;
            }
            if (a == UNKNOWN || b == UNKNOWN) {
                return UNKNOWN;
            }
            if (a == SAFE || b == SAFE) {
                return SAFE;
            }
            assert (a == NULL && b == NULL);
            return NULL;
        }

        static {
            $VALUES = new State[]{SAFE, NULL, UNKNOWN, TAINTED};
        }
    }
}

