/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintLocation;
import com.h3xstream.findsecbugs.taintanalysis.TaintSink;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public abstract class TaintDetector
implements Detector {
    private final BugReporter bugReporter;
    private final Map<String, Set<TaintSink>> methodsWithSinks = new HashMap<String, Set<TaintSink>>();

    protected TaintDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        ArrayList<InjectionSource> selectedSources = new ArrayList<InjectionSource>();
        for (InjectionSource source : this.getInjectionSource()) {
            if (!source.isCandidate(cpg)) continue;
            selectedSources.add(source);
        }
        if (selectedSources.isEmpty()) {
            // empty if block
        }
        for (Method method : classContext.getMethodsInCallOrder()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null) continue;
            try {
                this.analyzeMethod(classContext, method, selectedSources);
            }
            catch (CheckedAnalysisException e) {
                this.logException(classContext, method, (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.logException(classContext, method, e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method, Collection<InjectionSource> selectedSources) throws DataflowAnalysisException, CheckedAnalysisException {
        TaintDataflow dataflow = TaintDetector.getTaintDataFlow(classContext, method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        String currentMethod = TaintDetector.getFullMethodName(classContext.getMethodGen(method));
        Iterator<Location> i = TaintDetector.getLocationIterator(classContext, method);
        while (i.hasNext()) {
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction instruction = handle.getInstruction();
            if (!(instruction instanceof InvokeInstruction)) continue;
            InvokeInstruction invoke = (InvokeInstruction)instruction;
            TaintFrame fact = (TaintFrame)((Object)dataflow.getFactAtLocation(location));
            assert (fact != null);
            if (!fact.isValid()) continue;
            SourceLineAnnotation sourceLine = SourceLineAnnotation.fromVisitedInstruction((ClassContext)classContext, (Method)method, (InstructionHandle)handle);
            this.checkTaintSink(TaintDetector.getFullMethodName(cpg, invoke), fact, sourceLine, currentMethod);
            InjectionPoint injectionPoint = TaintDetector.getInjectionPoint(invoke, cpg, handle, selectedSources);
            for (int offset : injectionPoint.getInjectableArguments()) {
                Taint parameterTaint = (Taint)fact.getStackValue(offset);
                int priority = this.getPriority(parameterTaint);
                if (priority == 5) continue;
                BugInstance bugInstance = new BugInstance((Detector)this, injectionPoint.getBugType(), priority);
                bugInstance.addClassAndMethod(classContext.getJavaClass(), method);
                bugInstance.addSourceLine(sourceLine);
                if (injectionPoint.getInjectableMethod() != null) {
                    bugInstance.addString(injectionPoint.getInjectableMethod());
                }
                this.reportBug(bugInstance, parameterTaint, currentMethod);
            }
        }
    }

    private static Iterator<Location> getLocationIterator(ClassContext classContext, Method method) throws CheckedAnalysisException {
        try {
            return classContext.getCFG(method).locationIterator();
        }
        catch (CFGBuilderException ex) {
            throw new CheckedAnalysisException("cannot get control flow graph", (Throwable)ex);
        }
    }

    private void checkTaintSink(String calledMethod, TaintFrame fact, SourceLineAnnotation sourceLine, String currentMethod) throws DataflowAnalysisException {
        if (this.methodsWithSinks.containsKey(calledMethod)) {
            Set<TaintSink> sinks = this.methodsWithSinks.get(calledMethod);
            for (TaintSink sink : sinks) {
                BugInstance bugInstance;
                Taint sinkTaint = sink.getTaint();
                Set<Integer> taintParameters = sinkTaint.getParameters();
                Taint finalTaint = Taint.valueOf(sinkTaint.getNonParametricState());
                for (Integer offset : taintParameters) {
                    Taint parameterTaint = (Taint)fact.getStackValue(offset);
                    finalTaint = Taint.merge(finalTaint, parameterTaint);
                }
                if (finalTaint == null) continue;
                if (finalTaint.isTainted()) {
                    bugInstance = sink.getBugInstance();
                    bugInstance.setPriority(1);
                    bugInstance.addSourceLine(sourceLine);
                    continue;
                }
                if (!finalTaint.hasParameters()) continue;
                assert (finalTaint.isUnknown());
                bugInstance = sink.getBugInstance();
                bugInstance.addSourceLine(sourceLine);
                this.delayBugToReport(currentMethod, finalTaint, bugInstance);
            }
        }
    }

    private static InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle, Collection<InjectionSource> sources) {
        InjectionSource source;
        InjectionPoint injectionPoint = null;
        Iterator<InjectionSource> i$ = sources.iterator();
        while (i$.hasNext() && (injectionPoint = (source = i$.next()).getInjectableParameters(invoke, cpg, handle)) == InjectionPoint.NONE) {
        }
        if (injectionPoint == null) {
            injectionPoint = InjectionPoint.NONE;
        }
        return injectionPoint;
    }

    private void reportBug(BugInstance bugInstance, Taint taint, String currentMethod) {
        TaintDetector.addSourceLines(taint.getLocations(), bugInstance);
        if (bugInstance.getPriority() == 2 && taint.hasParameters()) {
            this.delayBugToReport(currentMethod, taint, bugInstance);
        } else {
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private void delayBugToReport(String method, Taint taint, BugInstance bug) {
        TaintSink taintSink = new TaintSink(taint, bug);
        Set<TaintSink> sinkSet = this.methodsWithSinks.get(method);
        if (sinkSet == null) {
            sinkSet = new HashSet<TaintSink>();
        }
        sinkSet.add(taintSink);
        this.methodsWithSinks.put(method, sinkSet);
    }

    private int getPriority(Taint taint) {
        if (taint.isTainted()) {
            return 1;
        }
        if (!taint.isSafe()) {
            return 2;
        }
        return 5;
    }

    private static void addSourceLines(Collection<TaintLocation> locations, BugInstance bugInstance) {
        LinkedList<SourceLineAnnotation> annotations = new LinkedList<SourceLineAnnotation>();
        for (TaintLocation location : locations) {
            SourceLineAnnotation taintSource = SourceLineAnnotation.fromVisitedInstruction((MethodDescriptor)location.getMethodDescriptor(), (int)location.getPosition());
            annotations.add(taintSource);
        }
        Collections.sort(annotations);
        SourceLineAnnotation annotation = null;
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            SourceLineAnnotation prev = annotation;
            annotation = (SourceLineAnnotation)it.next();
            if (prev == null || !prev.getClassName().equals(annotation.getClassName()) || prev.getStartLine() != annotation.getStartLine()) continue;
            it.remove();
        }
        for (SourceLineAnnotation sourceLine : annotations) {
            bugInstance.addSourceLine(sourceLine);
        }
    }

    private static TaintDataflow getTaintDataFlow(ClassContext classContext, Method method) throws CheckedAnalysisException {
        MethodDescriptor descriptor = BCELUtil.getMethodDescriptor((JavaClass)classContext.getJavaClass(), (Method)method);
        return (TaintDataflow)((Object)Global.getAnalysisCache().getMethodAnalysis(TaintDataflow.class, descriptor));
    }

    private void logException(ClassContext classContext, Method method, Exception ex) {
        this.bugReporter.logError("Exception while analyzing " + classContext.getFullyQualifiedMethodName(method), (Throwable)ex);
    }

    private static String getFullMethodName(ConstantPoolGen cpg, InvokeInstruction invoke) {
        String dottedClassName = invoke.getReferenceType(cpg).toString();
        StringBuilder builder = new StringBuilder(ClassName.toSlashedClassName((String)dottedClassName));
        builder.append(".").append(invoke.getMethodName(cpg)).append(invoke.getSignature(cpg));
        return builder.toString();
    }

    private static String getFullMethodName(MethodGen methodGen) {
        String methodNameWithSignature = methodGen.getName() + methodGen.getSignature();
        String slashedClassName = methodGen.getClassName().replace('.', '/');
        return slashedClassName + "." + methodNameWithSignature;
    }

    public void report() {
        HashSet<BugInstance> bugs = new HashSet<BugInstance>();
        for (Set<TaintSink> sinkSet : this.methodsWithSinks.values()) {
            for (TaintSink sink : sinkSet) {
                bugs.add(sink.getBugInstance());
            }
        }
        for (BugInstance bug : bugs) {
            this.bugReporter.reportBug(bug);
        }
    }

    public abstract InjectionSource[] getInjectionSource();
}

