/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.command;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class CommandInjectionSource
implements InjectionSource {
    private static final String COMMAND_INJECTION_TYPE = "COMMAND_INJECTION";
    private static final Map<String, int[]> injectableArgumentsMap = new HashMap<String, int[]>();

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8)) continue;
            String utf8String = ((ConstantUtf8)cnt).getBytes();
            if (utf8String.startsWith("java/lang/Runtime")) {
                return true;
            }
            if (!utf8String.startsWith("java/lang/ProcessBuilder")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKEVIRTUAL) {
            String methodName = ins.getMethodName(cpg);
            String className = ins.getClassName(cpg);
            if (className.equals("java.lang.Runtime") && methodName.equals("exec")) {
                String signature = ins.getSignature(cpg);
                int[] injectableArguments = injectableArgumentsMap.get(signature);
                if (injectableArguments != null) {
                    InjectionPoint ip = new InjectionPoint(injectableArguments, COMMAND_INJECTION_TYPE);
                    ip.setInjectableMethod("Runtime.exec(...)");
                    return ip;
                }
                assert (false) : "unknown exec signature " + signature;
            } else if (className.equals("java.lang.ProcessBuilder") && methodName.equals("command")) {
                InjectionPoint ip = new InjectionPoint(new int[]{0}, COMMAND_INJECTION_TYPE);
                ip.setInjectableMethod("ProcessBuilder.command(...)");
                return ip;
            }
        } else if (ins instanceof INVOKESPECIAL) {
            String methodName = ins.getMethodName(cpg);
            String className = ins.getClassName(cpg);
            if (className.equals("java.lang.ProcessBuilder") && methodName.equals("<init>")) {
                InjectionPoint ip = new InjectionPoint(new int[]{0}, COMMAND_INJECTION_TYPE);
                ip.setInjectableMethod("ProcessBuilder(...)");
                return ip;
            }
        }
        return InjectionPoint.NONE;
    }

    static {
        injectableArgumentsMap.put("(Ljava/lang/String;)Ljava/lang/Process;", new int[]{0});
        injectableArgumentsMap.put("([Ljava/lang/String;)Ljava/lang/Process;", new int[]{0});
        injectableArgumentsMap.put("(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Process;", new int[]{0, 1});
        injectableArgumentsMap.put("([Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Process;", new int[]{0, 1});
        injectableArgumentsMap.put("(Ljava/lang/String;[Ljava/lang/String;Ljava/io/File;)Ljava/lang/Process;", new int[]{1, 2});
        injectableArgumentsMap.put("([Ljava/lang/String;[Ljava/lang/String;Ljava/io/File;)Ljava/lang/Process;", new int[]{1, 2});
    }
}

