/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.ldap;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class JndiLdapInjectionSource
implements InjectionSource {
    private static final String LDAP_INJECTION_TYPE = "LDAP_INJECTION";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8)) continue;
            String utf8String = ((ConstantUtf8)cnt).getBytes();
            if (utf8String.equals("javax/naming/directory/InitialDirContext")) {
                return true;
            }
            if (utf8String.equals("javax/naming/directory/DirContext")) {
                return true;
            }
            if (utf8String.equals("javax/naming/ldap/InitialLdapContext")) {
                return true;
            }
            if (utf8String.equals("javax/naming/ldap/LdapContext")) {
                return true;
            }
            if (utf8String.equals("com/sun/jndi/ldap/LdapCtx")) {
                return true;
            }
            if (!utf8String.equals("javax/naming/event/EventDirContext")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        String methodName = ins.getMethodName(cpg);
        String methodSignature = ins.getSignature(cpg);
        String className = ins.getClassName(cpg);
        if (ins instanceof INVOKEVIRTUAL && className.equals("javax.naming.directory.InitialDirContext") && methodName.equals("search") || ins instanceof INVOKEINTERFACE && className.equals("javax.naming.directory.DirContext") && methodName.equals("search") || ins instanceof INVOKEVIRTUAL && className.equals("javax.naming.ldap.InitialLdapContext") && methodName.equals("search") || ins instanceof INVOKEINTERFACE && className.equals("javax.naming.ldap.LdapContext") && methodName.equals("search") || ins instanceof INVOKEVIRTUAL && className.equals("com.sun.jndi.ldap.LdapCtx") && methodName.equals("search") || ins instanceof INVOKEINTERFACE && className.equals("javax.naming.event.EventDirContext") && methodName.equals("search")) {
            if (methodSignature.equals("(Ljavax/naming/Name;Ljava/lang/String;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;")) {
                return new InjectionPoint(new int[]{1}, LDAP_INJECTION_TYPE);
            }
            if (methodSignature.equals("(Ljavax/naming/Name;Ljava/lang/String;[Ljava/lang/Object;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;")) {
                return new InjectionPoint(new int[]{2}, LDAP_INJECTION_TYPE);
            }
            if (methodSignature.equals("(Ljava/lang/String;Ljava/lang/String;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;")) {
                return new InjectionPoint(new int[]{1, 2}, LDAP_INJECTION_TYPE);
            }
            if (methodSignature.equals("(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;")) {
                return new InjectionPoint(new int[]{2, 3}, LDAP_INJECTION_TYPE);
            }
        }
        return InjectionPoint.NONE;
    }
}

