/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.redirect;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;

public class RedirectionSource
implements InjectionSource {
    private static final String UNVALIDATED_REDIRECT_TYPE = "UNVALIDATED_REDIRECT";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        for (int i = 0; i < cpg.getSize(); ++i) {
            String utf8String;
            Constant cnt = cpg.getConstant(i);
            if (!(cnt instanceof ConstantUtf8) || !(utf8String = ((ConstantUtf8)cnt).getBytes()).equals("javax/servlet/http/HttpServletResponse")) continue;
            return true;
        }
        return false;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        if (ins instanceof INVOKEINTERFACE) {
            String methodName = ins.getMethodName(cpg);
            String className = ins.getClassName(cpg);
            if (className.equals("javax.servlet.http.HttpServletResponse")) {
                Object value;
                LDC ldc;
                if (methodName.equals("sendRedirect")) {
                    return new InjectionPoint(new int[]{0}, UNVALIDATED_REDIRECT_TYPE);
                }
                if (methodName.equals("addHeader") && (ldc = ByteCode.getPrevInstruction(insHandle, LDC.class)) != null && "Location".equals(value = ldc.getValue(cpg))) {
                    return new InjectionPoint(new int[]{0}, UNVALIDATED_REDIRECT_TYPE);
                }
            }
        }
        return InjectionPoint.NONE;
    }
}

