/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.sql;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class JdbcInjectionSource
implements InjectionSource {
    protected static final String SQL_INJECTION_TYPE = "SQL_INJECTION_JDBC";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        return true;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        String methodName = ins.getMethodName(cpg);
        String methodSignature = ins.getSignature(cpg);
        String className = ins.getClassName(cpg);
        if (ins instanceof INVOKEINTERFACE) {
            if (className.equals("java.sql.Statement")) {
                if (methodName.equals("executeQuery") && methodSignature.equals("(Ljava/lang/String;)Ljava/sql/ResultSet;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("execute") && methodSignature.equals("(Ljava/lang/String;)Z")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("execute") && methodSignature.equals("(Ljava/lang/String;I)Z")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("execute") && methodSignature.equals("(Ljava/lang/String;[I)Z")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("execute") && methodSignature.equals("(Ljava/lang/String;[Ljava/lang/String;)Z")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeUpdate") && methodSignature.equals("(Ljava/lang/String;)I")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeUpdate") && methodSignature.equals("(Ljava/lang/String;I)I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeUpdate") && methodSignature.equals("(Ljava/lang/String;[I)I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeUpdate") && methodSignature.equals("(Ljava/lang/String;[Ljava/lang/String;)I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeLargeUpdate") && methodSignature.equals("(Ljava/lang/String;)J")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeLargeUpdate") && methodSignature.equals("(Ljava/lang/String;I)J")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeLargeUpdate") && methodSignature.equals("(Ljava/lang/String;[I)J")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("executeLargeUpdate") && methodSignature.equals("(Ljava/lang/String;[Ljava/lang/String;)J")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("addBatch") && methodSignature.equals("(Ljava/lang/String;)V")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
            } else if (className.equals("java.sql.Connection")) {
                if (methodName.equals("prepareCall") && methodSignature.equals("(Ljava/lang/String;)Ljava/sql/CallableStatement;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareCall") && methodSignature.equals("(Ljava/lang/String;II)Ljava/sql/CallableStatement;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareCall") && methodSignature.equals("(Ljava/lang/String;III)Ljava/sql/CallableStatement;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareStatement") && methodSignature.equals("(Ljava/lang/String;)Ljava/sql/PreparedStatement;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareStatement") && methodSignature.equals("(Ljava/lang/String;I)Ljava/sql/PreparedStatement;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareStatement") && methodSignature.equals("(Ljava/lang/String;II)Ljava/sql/PreparedStatement;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareStatement") && methodSignature.equals("(Ljava/lang/String;III)Ljava/sql/PreparedStatement;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareStatement") && methodSignature.equals("(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("prepareStatement") && methodSignature.equals("(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodName.equals("nativeSQL") && methodSignature.equals("(Ljava/lang/String;)Ljava/lang/String;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
            }
        }
        return InjectionPoint.NONE;
    }
}

