/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.sql;

import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.injection.InjectionSource;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class SpringJdbcInjectionSource
implements InjectionSource {
    protected static final String SQL_INJECTION_TYPE = "SQL_INJECTION_SPRING_JDBC";

    @Override
    public boolean isCandidate(ConstantPoolGen cpg) {
        return true;
    }

    @Override
    public InjectionPoint getInjectableParameters(InvokeInstruction ins, ConstantPoolGen cpg, InstructionHandle insHandle) {
        String methodName = ins.getMethodName(cpg);
        String methodSignature = ins.getSignature(cpg);
        String className = ins.getClassName(cpg);
        if (ins instanceof INVOKESPECIAL) {
            if (className.equals("org.springframework.jdbc.core.PreparedStatementCreatorFactory") && methodName.equals("<init>")) {
                if (methodSignature.equals("(Ljava/lang/String;)V")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[I)V") || methodSignature.equals("(Ljava/lang/String;Ljava/util/List;)V")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
            }
        } else if (ins instanceof INVOKEVIRTUAL && className.equals("org.springframework.jdbc.core.JdbcTemplate") || ins instanceof INVOKEINTERFACE && className.equals("org.springframework.jdbc.core.JdbcOperations")) {
            if (methodName.equals("execute")) {
                if (methodSignature.equals("(Ljava/lang/String;)V")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/PreparedStatementCallback;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/CallableStatementCallback;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("batchUpdate")) {
                if (methodSignature.equals("([Ljava/lang/String;)[I")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/BatchPreparedStatementSetter;)[I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/BatchPreparedStatementSetter;)[I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/util/Collection;ILorg/springframework/jdbc/core/ParameterizedPreparedStatementSetter;)[[I")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/util/List;)[I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/util/List;[I)[I")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("queryForObject")) {
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/RowMapper;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/RowMapper;[Ljava/lang/Object;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[ILjava/lang/Class;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[ILorg/springframework/jdbc/core/RowMapper;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;Lorg/springframework/jdbc/core/RowMapper;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("query")) {
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/ResultSetExtractor;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/RowCallbackHandler;)V")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/RowMapper;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/PreparedStatementSetter;Lorg/springframework/jdbc/core/ResultSetExtractor;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/PreparedStatementSetter;Lorg/springframework/jdbc/core/RowCallbackHandler;)V")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Lorg/springframework/jdbc/core/PreparedStatementSetter;Lorg/springframework/jdbc/core/RowMapper;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;Lorg/springframework/jdbc/core/RowMapper;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;Lorg/springframework/jdbc/core/RowCallbackHandler;)V")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;Lorg/springframework/jdbc/core/ResultSetExtractor;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[ILorg/springframework/jdbc/core/ResultSetExtractor;)Ljava/lang/Object;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[ILorg/springframework/jdbc/core/RowMapper;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[ILorg/springframework/jdbc/core/RowCallbackHandler;)V")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("queryForList")) {
                if (methodSignature.equals("(Ljava/lang/String;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;Ljava/lang/Class;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[I)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[ILjava/lang/Class;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{3}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/List;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("queryForMap")) {
                if (methodSignature.equals("(Ljava/lang/String;)Ljava/util/Map;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/Map;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[I)Ljava/util/Map;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("queryForRowSet")) {
                if (methodSignature.equals("(Ljava/lang/String;)Lorg/springframework/jdbc/support/rowset/SqlRowSet;")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;)Lorg/springframework/jdbc/support/rowset/SqlRowSet;")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[I)Lorg/springframework/jdbc/support/rowset/SqlRowSet;")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("queryForInt")) {
                if (methodSignature.equals("(Ljava/lang/String;)I")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;)I")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[I)I")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            } else if (methodName.equals("queryForLong")) {
                if (methodSignature.equals("(Ljava/lang/String;)J")) {
                    return new InjectionPoint(new int[]{0}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;)J")) {
                    return new InjectionPoint(new int[]{1}, SQL_INJECTION_TYPE);
                }
                if (methodSignature.equals("(Ljava/lang/String;[Ljava/lang/Object;[I)J")) {
                    return new InjectionPoint(new int[]{2}, SQL_INJECTION_TYPE);
                }
            }
        }
        return InjectionPoint.NONE;
    }
}

