/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TaintMethodSummary {
    private Taint outputTaint = null;
    private final Set<Integer> mutableStackIndices = new HashSet<Integer>();
    public static final TaintMethodSummary DEFAULT_TOSTRING_SUMMARY = new TaintMethodSummary();
    public static final TaintMethodSummary DEFAULT_EQUALS_SUMMARY;
    public static final TaintMethodSummary SAFE_SUMMARY;

    public Collection<Integer> getMutableStackIndeces() {
        if (!this.hasMutableStackIndeces()) {
            throw new IllegalStateException("stack indeces not set");
        }
        return Collections.unmodifiableCollection(this.mutableStackIndices);
    }

    public boolean hasMutableStackIndeces() {
        assert (this.mutableStackIndices != null);
        return !this.mutableStackIndices.isEmpty();
    }

    public void addMutableStackIndex(int mutableStackIndex) {
        if (mutableStackIndex < 0) {
            throw new IllegalArgumentException("negative index");
        }
        this.mutableStackIndices.add(mutableStackIndex);
    }

    public Taint getOutputTaint() {
        if (this.outputTaint == null) {
            return null;
        }
        return new Taint(this.outputTaint);
    }

    public void setOuputTaint(Taint taint) {
        if (taint == null) {
            this.outputTaint = null;
            return;
        }
        Taint taintCopy = new Taint(taint);
        taintCopy.invalidateVariableIndex();
        this.outputTaint = taintCopy;
    }

    public static TaintMethodSummary getDefaultConstructorSummary(int stackSize) {
        if (stackSize < 0) {
            throw new IllegalArgumentException("negative index");
        }
        TaintMethodSummary summary = new TaintMethodSummary();
        summary.outputTaint = new Taint(Taint.State.UNKNOWN);
        summary.mutableStackIndices.add(stackSize - 1);
        summary.mutableStackIndices.add(stackSize);
        return summary;
    }

    public boolean isInformative() {
        if (this == DEFAULT_TOSTRING_SUMMARY || this == SAFE_SUMMARY) {
            return false;
        }
        if (this.outputTaint == null) {
            return false;
        }
        if (!this.outputTaint.isUnknown()) {
            return true;
        }
        return this.outputTaint.hasParameters();
    }

    public String toString() {
        if (this.outputTaint == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.outputTaint.isUnknown() && this.outputTaint.hasParameters()) {
            TaintMethodSummary.appendJoined(sb, this.outputTaint.getParameters());
            Taint.State nonParametricState = this.outputTaint.getNonParametricState();
            assert (nonParametricState != null);
            if (nonParametricState != Taint.State.INVALID) {
                sb.append(",").append(nonParametricState.name());
            }
        } else {
            sb.append(this.outputTaint.getState().name());
        }
        if (this.hasMutableStackIndeces()) {
            sb.append("#");
            TaintMethodSummary.appendJoined(sb, this.mutableStackIndices);
        }
        return sb.toString();
    }

    private static void appendJoined(StringBuilder sb, Collection<Integer> objects) {
        assert (sb != null && objects != null);
        int count = objects.size();
        Integer[] array = objects.toArray(new Integer[count]);
        sb.append(array[0]);
        for (int i = 1; i < count; ++i) {
            sb.append(",").append(array[i]);
        }
    }

    public static TaintMethodSummary load(String str) throws IOException {
        if (str == null) {
            throw new NullPointerException("string is null");
        }
        str = str.trim();
        String[] tuple = str.split("#");
        TaintMethodSummary summary = new TaintMethodSummary();
        if (tuple.length == 2) {
            str = tuple[0];
            try {
                String[] indices;
                for (String index : indices = tuple[1].split(",")) {
                    summary.addMutableStackIndex(Integer.parseInt(index.trim()));
                }
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot parse mutable stack offsets", ex);
            }
        } else if (tuple.length != 1) {
            throw new IOException("Bad format: only one '#' expected");
        }
        if (str.isEmpty()) {
            throw new IOException("No taint information set");
        }
        if (TaintMethodSummary.isTaintStateValue(str)) {
            summary.setOuputTaint(Taint.valueOf(str));
        } else {
            tuple = str.split(",");
            int count = tuple.length;
            Taint taint = new Taint(Taint.State.UNKNOWN);
            for (int i = 0; i < count; ++i) {
                try {
                    taint.addParameter(Integer.parseInt(tuple[i].trim()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Cannot parse parameter offset " + i, ex);
                }
            }
            summary.setOuputTaint(taint);
        }
        return summary;
    }

    private static boolean isTaintStateValue(String value) {
        Taint.State[] states;
        assert (value != null && !value.isEmpty());
        for (Taint.State state : states = Taint.State.values()) {
            if (!state.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    static {
        TaintMethodSummary.DEFAULT_TOSTRING_SUMMARY.outputTaint = new Taint(Taint.State.UNKNOWN);
        TaintMethodSummary.DEFAULT_TOSTRING_SUMMARY.outputTaint.addParameter(0);
        DEFAULT_EQUALS_SUMMARY = new TaintMethodSummary();
        TaintMethodSummary.DEFAULT_EQUALS_SUMMARY.outputTaint = new Taint(Taint.State.UNKNOWN);
        SAFE_SUMMARY = new TaintMethodSummary();
        TaintMethodSummary.SAFE_SUMMARY.outputTaint = new Taint(Taint.State.SAFE);
    }
}

