/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;

public class StaticIvDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String STATIC_IV = "STATIC_IV";
    private BugReporter bugReporter;

    public StaticIvDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException e) {
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        INVOKEVIRTUAL invoke;
        Instruction inst;
        Location location;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        boolean foundSafeIvGeneration = false;
        boolean atLeastOneDecryptCipher = false;
        boolean atLeastOneEncryptCipher = false;
        boolean ivFetchFromCipher = false;
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            location = this.nextLocation(i, cpg);
            inst = location.getHandle().getInstruction();
            if (!(inst instanceof INVOKEVIRTUAL)) continue;
            invoke = (INVOKEVIRTUAL)inst;
            if ("javax.crypto.Cipher".equals(invoke.getClassName(cpg)) && "init".equals(invoke.getMethodName(cpg))) {
                ICONST iconst = ByteCode.getPrevInstruction(location.getHandle(), ICONST.class);
                if (iconst == null) continue;
                int mode = iconst.getValue().intValue();
                switch (mode) {
                    case 1: {
                        atLeastOneEncryptCipher = true;
                        break;
                    }
                    case 2: {
                        atLeastOneDecryptCipher = true;
                    }
                }
                continue;
            }
            if (!"javax.crypto.Cipher".equals(invoke.getClassName(cpg)) || !"getIV".equals(invoke.getMethodName(cpg))) continue;
            ivFetchFromCipher = true;
        }
        i = cfg.locationIterator();
        while (i.hasNext()) {
            location = this.nextLocation(i, cpg);
            inst = location.getHandle().getInstruction();
            if (inst instanceof INVOKEVIRTUAL) {
                invoke = (INVOKEVIRTUAL)inst;
                if (!"java.security.SecureRandom".equals(invoke.getClassName(cpg)) || !"nextBytes".equals(invoke.getMethodName(cpg))) continue;
                foundSafeIvGeneration = true;
                continue;
            }
            if (!(inst instanceof INVOKESPECIAL) || ivFetchFromCipher || atLeastOneDecryptCipher && !atLeastOneEncryptCipher || foundSafeIvGeneration || !"javax.crypto.spec.IvParameterSpec".equals((invoke = (INVOKESPECIAL)inst).getClassName(cpg)) || !"<init>".equals(invoke.getMethodName(cpg))) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, STATIC_IV, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
        }
    }

    private Location nextLocation(Iterator<Location> i, ConstantPoolGen cpg) {
        Location loc = i.next();
        return loc;
    }

    public void report() {
    }
}

