/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.jsp;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;

public class JstlOutDetector
implements Detector {
    private static final String JSP_JSTL_OUT = "JSP_JSTL_OUT";
    private final BugReporter bugReporter;

    public JstlOutDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException e) {
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        boolean escapeXmlSetToFalse = false;
        Location locationWeakness = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Integer value;
            INVOKEVIRTUAL invoke;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof INVOKEVIRTUAL) || !"org.apache.taglibs.standard.tag.rt.core.OutTag".equals((invoke = (INVOKEVIRTUAL)inst).getClassName(cpg)) || !"setEscapeXml".equals(invoke.getMethodName(cpg)) || !"(Z)V".equals(invoke.getSignature(cpg)) || (value = ByteCode.getConstantInt(location.getHandle().getPrev())) == null || value != 0) continue;
            escapeXmlSetToFalse = true;
            locationWeakness = location;
        }
        if (escapeXmlSetToFalse) {
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, JSP_JSTL_OUT, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        }
    }

    public void report() {
    }
}

